/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.SignatureCertificateSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESCertificateSource
extends SignatureCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESCertificateSource.class);
    private final CMSSignedData cmsSignedData;
    private final SignerInformation signerInformation;
    private List<CertificateToken> keyInfoCerts;
    private List<CertificateToken> encapsulatedCerts;

    public CAdESCertificateSource(CMSSignedData cmsSignedData, CertificatePool certPool) {
        super(certPool);
        if (cmsSignedData == null) {
            throw new DSSException("CMS SignedData is null, it must be provided!");
        }
        this.cmsSignedData = cmsSignedData;
        this.signerInformation = DSSASN1Utils.getFirstSignerInformation((CMSSignedData)cmsSignedData);
        if (this.certificateTokens == null) {
            this.certificateTokens = new ArrayList();
            this.keyInfoCerts = this.extractIdSignedDataCertificates();
            this.encapsulatedCerts = this.extractEncapsulatedCertificates();
        }
    }

    public List<CertificateToken> getEncapsulatedCertificates() {
        return this.encapsulatedCerts;
    }

    private List<CertificateToken> extractEncapsulatedCertificates() {
        ArrayList<CertificateToken> encapsulatedCerts = new ArrayList<CertificateToken>();
        if (this.signerInformation != null && this.signerInformation.getUnsignedAttributes() != null) {
            this.extractCertificateFromUnsignedAttribute(encapsulatedCerts, PKCSObjectIdentifiers.id_aa_ets_certValues);
            this.extractCertificateFromUnsignedAttribute(encapsulatedCerts, PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
        }
        return encapsulatedCerts;
    }

    private void extractCertificateFromUnsignedAttribute(List<CertificateToken> encapsulatedCerts, ASN1ObjectIdentifier oid) {
        Attribute attribute = this.signerInformation.getUnsignedAttributes().get(oid);
        if (attribute != null) {
            ASN1Sequence seq = (ASN1Sequence)attribute.getAttrValues().getObjectAt(0);
            for (int ii = 0; ii < seq.size(); ++ii) {
                try {
                    Certificate cs = Certificate.getInstance((Object)seq.getObjectAt(ii));
                    CertificateToken certToken = this.addCertificate(DSSUtils.loadCertificate((byte[])cs.getEncoded()));
                    if (encapsulatedCerts.contains(certToken)) continue;
                    encapsulatedCerts.add(certToken);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to parse encapsulated certificate : " + e.getMessage());
                }
            }
        }
    }

    public List<CertificateToken> getKeyInfoCertificates() {
        return this.keyInfoCerts;
    }

    private List<CertificateToken> extractIdSignedDataCertificates() {
        ArrayList<CertificateToken> essCertIDCerts = new ArrayList<CertificateToken>();
        try {
            Collection x509CertificateHolders = this.cmsSignedData.getCertificates().getMatches(null);
            for (X509CertificateHolder x509CertificateHolder : x509CertificateHolders) {
                CertificateToken x509Certificate = DSSASN1Utils.getCertificate((X509CertificateHolder)x509CertificateHolder);
                CertificateToken certificateToken = this.addCertificate(x509Certificate);
                if (essCertIDCerts.contains(certificateToken)) continue;
                essCertIDCerts.add(certificateToken);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot extract certificates from CMS Signed Data : " + e.getMessage());
        }
        return essCertIDCerts;
    }
}

