/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSRevocationUtils;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureScope;
import eu.europa.esig.dss.validation.SignatureScopeFinder;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampReferenceCategory;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationOrigin;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.SignaturePolicy;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.crl.ListCRLSource;
import eu.europa.esig.dss.x509.crl.OfflineCRLSource;
import eu.europa.esig.dss.x509.ocsp.ListOCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import eu.europa.esig.dss.x509.ocsp.OfflineOCSPSource;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;

public abstract class DefaultAdvancedSignature
implements AdvancedSignature {
    protected final CertificatePool certPool;
    protected CertificateToken providedSigningCertificateToken;
    protected List<DSSDocument> detachedContents;
    protected SignatureCryptographicVerification signatureCryptographicVerification;
    protected String structureValidation;
    protected CandidatesForSigningCertificate candidatesForSigningCertificate;
    protected List<TimestampToken> contentTimestamps;
    protected transient List<TimestampToken> signatureTimestamps;
    protected List<TimestampToken> sigAndRefsTimestamps;
    protected List<TimestampToken> refsOnlyTimestamps;
    protected List<TimestampToken> archiveTimestamps;
    protected OfflineCRLSource offlineCRLSource;
    protected OfflineOCSPSource offlineOCSPSource;
    private AdvancedSignature masterSignature;
    protected SignaturePolicy signaturePolicy;
    protected Set<DigestAlgorithm> usedCertificatesDigestAlgorithms = new HashSet<DigestAlgorithm>();
    private List<SignatureScope> signatureScopes;
    private String signatureFilename;

    protected DefaultAdvancedSignature(CertificatePool certPool) {
        this.certPool = certPool;
    }

    @Override
    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    @Override
    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.detachedContents;
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public SignatureLevel getDataFoundUpToLevel() {
        SignatureLevel[] signatureLevels = this.getSignatureLevels();
        SignatureLevel dataFoundUpToProfile = this.getDataFoundUpToProfile(signatureLevels);
        return dataFoundUpToProfile;
    }

    private SignatureLevel getDataFoundUpToProfile(SignatureLevel ... signatureLevels) {
        for (int ii = signatureLevels.length - 1; ii >= 0; --ii) {
            SignatureLevel signatureLevel = signatureLevels[ii];
            if (!this.isDataForSignatureLevelPresent(signatureLevel)) continue;
            return signatureLevel;
        }
        return null;
    }

    public ValidationContext getSignatureValidationContext(CertificateVerifier certificateVerifier) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        List<CertificateToken> certificates = this.getCertificates();
        for (CertificateToken certificate : certificates) {
            validationContext.addCertificateTokenForVerification(certificate);
        }
        this.prepareTimestamps(validationContext);
        certificateVerifier.setSignatureCRLSource(new ListCRLSource(this.getCRLSource()));
        certificateVerifier.setSignatureOCSPSource(new ListOCSPSource(this.getOCSPSource()));
        validationContext.initialize(certificateVerifier);
        validationContext.validate();
        return validationContext;
    }

    public Set<CertificateToken> getCertificatesForInclusion(ValidationContext validationContext) {
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        List<CertificateToken> certWithinSignatures = this.getCertificatesWithinSignatureAndTimestamps();
        for (CertificateToken certificateToken : validationContext.getProcessedCertificates()) {
            if (certWithinSignatures.contains(certificateToken)) continue;
            certificates.add(certificateToken);
        }
        return certificates;
    }

    public List<CertificateToken> getCertificatesWithinSignatureAndTimestamps() {
        ArrayList<CertificateToken> certWithinSignatures = new ArrayList<CertificateToken>();
        certWithinSignatures.addAll(this.getCertificates());
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            certWithinSignatures.addAll(timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            certWithinSignatures.addAll(timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            certWithinSignatures.addAll(timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            certWithinSignatures.addAll(timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            certWithinSignatures.addAll(timestampToken.getCertificates());
        }
        return certWithinSignatures;
    }

    public RevocationDataForInclusion getRevocationDataForInclusion(ValidationContext validationContext) {
        Set<RevocationToken> revocationTokens = validationContext.getProcessedRevocations();
        ArrayList<CRLToken> crlTokens = new ArrayList<CRLToken>();
        ArrayList<OCSPToken> ocspTokens = new ArrayList<OCSPToken>();
        for (RevocationToken revocationToken : revocationTokens) {
            if (RevocationOrigin.SIGNATURE.equals((Object)revocationToken.getOrigin())) continue;
            if (revocationToken instanceof CRLToken) {
                CRLToken crlToken = (CRLToken)revocationToken;
                crlTokens.add(crlToken);
                continue;
            }
            if (revocationToken instanceof OCSPToken) {
                OCSPToken ocspToken = (OCSPToken)revocationToken;
                ocspTokens.add(ocspToken);
                continue;
            }
            throw new DSSException("Unknown type for revocationToken: " + revocationToken.getClass().getName());
        }
        return new RevocationDataForInclusion(crlTokens, ocspTokens);
    }

    @Override
    public void setMasterSignature(AdvancedSignature masterSignature) {
        this.masterSignature = masterSignature;
    }

    @Override
    public AdvancedSignature getMasterSignature() {
        return this.masterSignature;
    }

    @Override
    public SignatureCryptographicVerification getSignatureCryptographicVerification() {
        if (this.signatureCryptographicVerification == null) {
            this.checkSignatureIntegrity();
        }
        return this.signatureCryptographicVerification;
    }

    @Override
    public CertificateToken getProvidedSigningCertificateToken() {
        return this.providedSigningCertificateToken;
    }

    @Override
    public void setProvidedSigningCertificateToken(CertificateToken certificateToken) {
        this.providedSigningCertificateToken = certificateToken;
    }

    @Override
    public CertificateToken getSigningCertificateToken() {
        this.candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
        this.checkSignatureIntegrity();
        this.signatureCryptographicVerification = this.getSignatureCryptographicVerification();
        CertificateValidity theCertificateValidity = this.candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null && theCertificateValidity.isValid()) {
            CertificateToken signingCertificateToken = theCertificateValidity.getCertificateToken();
            return signingCertificateToken;
        }
        CertificateValidity theBestCandidate = this.candidatesForSigningCertificate.getTheBestCandidate();
        return theBestCandidate == null ? null : theBestCandidate.getCertificateToken();
    }

    @Override
    public void prepareTimestamps(ValidationContext validationContext) {
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
    }

    @Override
    public void validateTimestamps() {
        byte[] timestampBytes;
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            timestampBytes = this.getContentTimestampData(timestampToken);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            timestampBytes = this.getSignatureTimestampData(timestampToken, null);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            timestampBytes = this.getTimestampX1Data(timestampToken, null);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            timestampBytes = this.getTimestampX2Data(timestampToken, null);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            if (timestampToken.isProcessed()) continue;
            byte[] timestampData = this.getArchiveTimestampData(timestampToken, null);
            timestampToken.matchData(timestampData);
        }
    }

    @Override
    public void validateStructure() {
    }

    @Override
    public String getStructureValidationResult() {
        return this.structureValidation;
    }

    protected void addReferencesFromOfflineOCSPSource(List<TimestampReference> references) {
        List containedOCSPResponses;
        OfflineOCSPSource ocspSource = this.getOCSPSource();
        if (ocspSource != null && Utils.isCollectionNotEmpty((Collection)(containedOCSPResponses = ocspSource.getContainedOCSPResponses()))) {
            this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
            for (BasicOCSPResp basicOCSPResp : containedOCSPResponses) {
                OCSPResp ocspResp = DSSRevocationUtils.fromBasicToResp((BasicOCSPResp)basicOCSPResp);
                byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])DSSRevocationUtils.getEncoded((OCSPResp)ocspResp));
                references.add(new TimestampReference(DigestAlgorithm.SHA1, Utils.toBase64((byte[])digest), TimestampReferenceCategory.REVOCATION));
            }
        }
    }

    protected void addReferencesFromOfflineCRLSource(List<TimestampReference> references) {
        List containedX509CRLs;
        OfflineCRLSource crlSource = this.getCRLSource();
        if (crlSource != null && Utils.isCollectionNotEmpty((Collection)(containedX509CRLs = crlSource.getContainedX509CRLs()))) {
            this.usedCertificatesDigestAlgorithms.add(DigestAlgorithm.SHA1);
            for (X509CRL x509crl : containedX509CRLs) {
                byte[] digest = DSSUtils.digest((DigestAlgorithm)DigestAlgorithm.SHA1, (byte[])DSSRevocationUtils.getEncoded((X509CRL)x509crl));
                references.add(new TimestampReference(DigestAlgorithm.SHA1, Utils.toBase64((byte[])digest), TimestampReferenceCategory.REVOCATION));
            }
        }
    }

    @Override
    public Set<DigestAlgorithm> getUsedCertificatesDigestAlgorithms() {
        return this.usedCertificatesDigestAlgorithms;
    }

    @Override
    public SignaturePolicy getPolicyId() {
        return this.signaturePolicy;
    }

    @Override
    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyDetector) {
    }

    @Override
    public void findSignatureScope(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopes = signatureScopeFinder.findSignatureScope(this);
    }

    @Override
    public List<SignatureScope> getSignatureScopes() {
        return this.signatureScopes;
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (!timestamp.isProcessed()) {
            throw new DSSException("Timestamp token must be validated first !");
        }
        if (TimestampType.ARCHIVE_TIMESTAMP != timestamp.getTimeStampType()) {
            throw new DSSException("Only archival timestamp is allowed !");
        }
        if (this.archiveTimestamps == null) {
            this.archiveTimestamps = new ArrayList<TimestampToken>();
        }
        this.archiveTimestamps.add(timestamp);
    }

    public static class RevocationDataForInclusion {
        public final List<CRLToken> crlTokens;
        public final List<OCSPToken> ocspTokens;

        public RevocationDataForInclusion(List<CRLToken> crlTokens, List<OCSPToken> ocspTokens) {
            this.crlTokens = crlTokens;
            this.ocspTokens = ocspTokens;
        }

        public boolean isEmpty() {
            return this.crlTokens.isEmpty() && this.ocspTokens.isEmpty();
        }
    }
}

