/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.validation.CRLCertificateVerifier;
import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.validation.OCSPCertificateVerifier;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPAndCRLCertificateVerifier
implements CertificateStatusVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPAndCRLCertificateVerifier.class);
    private OCSPSource ocspSource;
    private CRLSource crlSource;
    private final CertificatePool validationCertPool;

    public OCSPAndCRLCertificateVerifier(CRLSource crlSource, OCSPSource ocspSource, CertificatePool validationCertPool) {
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
        this.validationCertPool = validationCertPool;
    }

    @Override
    public RevocationToken check(CertificateToken certificateToken) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Check revocation for certificate : " + certificateToken.getDSSIdAsString());
        }
        RevocationToken result = null;
        if (this.ocspSource != null && (result = this.checkOCSP(certificateToken)) != null) {
            return result;
        }
        if (this.crlSource != null && (result = this.checkCRL(certificateToken)) != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("There is no response for " + certificateToken.getDSSIdAsString() + " neither from OCSP nor from CRL!");
        }
        return null;
    }

    public RevocationToken checkOCSP(CertificateToken certificateToken) {
        RevocationToken revocation;
        OCSPCertificateVerifier ocspVerifier = new OCSPCertificateVerifier(this.ocspSource, this.validationCertPool);
        if (LOG.isDebugEnabled()) {
            LOG.debug("OCSP request for: " + certificateToken.getDSSIdAsString() + " using: " + this.ocspSource.getClass().getSimpleName());
        }
        if ((revocation = ocspVerifier.check(certificateToken)) != null && revocation.getStatus() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("OCSP response for " + certificateToken.getDSSIdAsString() + " retrieved: " + revocation.getAbbreviation());
            }
            return revocation;
        }
        return null;
    }

    public RevocationToken checkCRL(CertificateToken certificateToken) {
        RevocationToken revocationToken;
        CRLCertificateVerifier crlVerifier = new CRLCertificateVerifier(this.crlSource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CRL request for: " + certificateToken.getDSSIdAsString() + " using: " + this.crlSource.getClass().getSimpleName());
        }
        if ((revocationToken = crlVerifier.check(certificateToken)) != null && revocationToken.getStatus() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CRL for " + certificateToken.getDSSIdAsString() + " retrieved: " + revocationToken.getAbbreviation());
            }
            return revocationToken;
        }
        return null;
    }
}

