/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPCertificateVerifier
implements CertificateStatusVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPCertificateVerifier.class);
    private final OCSPSource ocspSource;
    private final CertificatePool validationCertPool;

    public OCSPCertificateVerifier(OCSPSource ocspSource, CertificatePool validationCertPool) {
        this.ocspSource = ocspSource;
        this.validationCertPool = validationCertPool;
    }

    @Override
    public RevocationToken check(CertificateToken toCheckToken) {
        if (this.ocspSource == null) {
            LOG.warn("OCSPSource null");
            toCheckToken.extraInfo().infoOCSPSourceIsNull();
            return null;
        }
        try {
            OCSPToken ocspToken = this.ocspSource.getOCSPToken(toCheckToken, toCheckToken.getIssuerToken());
            if (ocspToken == null) {
                LOG.debug("No matching OCSP response found for " + toCheckToken.getDSSIdAsString());
            } else {
                ocspToken.extractInfo();
                boolean found = this.extractSigningCertificateFromResponse(ocspToken);
                if (!found) {
                    this.extractSigningCertificateFormResponderId(ocspToken);
                }
                toCheckToken.addRevocationToken((RevocationToken)ocspToken);
            }
            return ocspToken;
        }
        catch (DSSException e) {
            LOG.error("OCSP DSS Exception: " + e.getMessage(), (Throwable)e);
            toCheckToken.extraInfo().infoOCSPException(e.getMessage());
            return null;
        }
    }

    private boolean extractSigningCertificateFromResponse(OCSPToken ocspToken) {
        BasicOCSPResp basicOCSPResp = ocspToken.getBasicOCSPResp();
        if (basicOCSPResp != null) {
            for (X509CertificateHolder x509CertificateHolder : basicOCSPResp.getCerts()) {
                CertificateToken certificateToken = DSSASN1Utils.getCertificate((X509CertificateHolder)x509CertificateHolder);
                CertificateToken certToken = this.validationCertPool.getInstance(certificateToken, CertificateSourceType.OCSP_RESPONSE);
                if (!ocspToken.isSignedBy(certToken)) continue;
                return true;
            }
        }
        return false;
    }

    private void extractSigningCertificateFormResponderId(OCSPToken ocspToken) {
        block2: {
            CertificateToken issuerCertificateToken;
            BasicOCSPResp basicOCSPResp = ocspToken.getBasicOCSPResp();
            if (basicOCSPResp == null) break block2;
            RespID responderId = basicOCSPResp.getResponderId();
            ResponderID responderIdAsASN1Object = responderId.toASN1Primitive();
            DERTaggedObject derTaggedObject = (DERTaggedObject)responderIdAsASN1Object.toASN1Primitive();
            if (2 == derTaggedObject.getTagNo()) {
                throw new DSSException("Certificate's key hash management not implemented yet!");
            }
            ASN1Primitive derObject = derTaggedObject.getObject();
            byte[] derEncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)derObject);
            X500Principal x500Principal_ = new X500Principal(derEncoded);
            X500Principal x500Principal = DSSUtils.getNormalizedX500Principal((X500Principal)x500Principal_);
            List certificateTokens = this.validationCertPool.get(x500Principal);
            Iterator i$ = certificateTokens.iterator();
            while (i$.hasNext() && !ocspToken.isSignedBy(issuerCertificateToken = (CertificateToken)i$.next())) {
            }
        }
    }
}

