/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.client.http.DataLoader;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.OCSPAndCRLCertificateVerifier;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.validation.TimestampToken;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.Token;
import eu.europa.esig.dss.x509.crl.CRLSource;
import eu.europa.esig.dss.x509.ocsp.OCSPSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements ValidationContext {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationContext.class);
    private final Set<CertificateToken> processedCertificates = new HashSet<CertificateToken>();
    private final Set<RevocationToken> processedRevocations = new HashSet<RevocationToken>();
    private final Set<TimestampToken> processedTimestamps = new HashSet<TimestampToken>();
    private DataLoader dataLoader;
    protected CertificatePool validationCertificatePool;
    private final Map<Token, Boolean> tokensToProcess = new HashMap<Token, Boolean>();
    private OCSPSource ocspSource;
    private CRLSource crlSource;
    private CRLSource signatureCRLSource;
    private OCSPSource signatureOCSPSource;
    private List<TimestampReference> timestampedReferences;
    protected Date currentTime = new Date();

    public SignatureValidationContext() {
    }

    public SignatureValidationContext(CertificatePool validationCertificatePool) {
        if (validationCertificatePool == null) {
            throw new NullPointerException();
        }
        this.validationCertificatePool = validationCertificatePool;
    }

    @Override
    public void initialize(CertificateVerifier certificateVerifier) {
        if (certificateVerifier == null) {
            throw new NullPointerException();
        }
        if (this.validationCertificatePool == null) {
            this.validationCertificatePool = certificateVerifier.createValidationPool();
        }
        this.crlSource = certificateVerifier.getCrlSource();
        this.ocspSource = certificateVerifier.getOcspSource();
        this.dataLoader = certificateVerifier.getDataLoader();
        this.signatureCRLSource = certificateVerifier.getSignatureCRLSource();
        this.signatureOCSPSource = certificateVerifier.getSignatureOCSPSource();
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public void setCurrentTime(Date currentTime) {
        if (currentTime == null) {
            throw new NullPointerException();
        }
        this.currentTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNotYetVerifiedToken() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }
    }

    private CertificateToken getIssuerCertificate(Token token) throws DSSException {
        if (token.isTrusted()) {
            return null;
        }
        if (token.getIssuerToken() != null) {
            return token.getIssuerToken();
        }
        X500Principal issuerX500Principal = token.getIssuerX500Principal();
        CertificateToken issuerCertificateToken = this.getIssuerFromPool(token, issuerX500Principal);
        if (issuerCertificateToken == null && token instanceof CertificateToken) {
            issuerCertificateToken = this.getIssuerFromAIA((CertificateToken)token);
        }
        if (issuerCertificateToken == null) {
            token.extraInfo().infoTheSigningCertNotFound();
        }
        if (issuerCertificateToken != null && !issuerCertificateToken.isTrusted() && !issuerCertificateToken.isSelfSigned()) {
            this.getIssuerCertificate((Token)issuerCertificateToken);
        }
        return issuerCertificateToken;
    }

    private CertificateToken getIssuerFromAIA(CertificateToken token) {
        try {
            LOG.info("Retrieving {} certificate's issuer using AIA.", (Object)token.getAbbreviation());
            Collection issuerCerts = DSSUtils.loadIssuerCertificates((CertificateToken)token, (DataLoader)this.dataLoader);
            if (issuerCerts != null) {
                CertificateToken issuerCertToken = null;
                for (CertificateToken issuerCert : issuerCerts) {
                    CertificateToken issuerCertFromAia = this.validationCertificatePool.getInstance(issuerCert, CertificateSourceType.AIA);
                    if (token.isSignedBy(issuerCertFromAia)) {
                        issuerCertToken = issuerCertFromAia;
                    } else {
                        this.addCertificateTokenForVerification(issuerCertFromAia);
                    }
                    LOG.info("The retrieved certificate using AIA does not sign the certificate {}.", (Object)token.getAbbreviation());
                }
                return issuerCertToken;
            }
            LOG.info("The issuer certificate cannot be loaded using AIA.");
        }
        catch (DSSException e) {
            LOG.error(e.getMessage());
        }
        return null;
    }

    private CertificateToken getIssuerFromPool(Token token, X500Principal issuerX500Principal) {
        List issuerCertList = this.validationCertificatePool.get(issuerX500Principal);
        for (CertificateToken issuerCertToken : issuerCertList) {
            if (!token.isSignedBy(issuerCertToken)) continue;
            return issuerCertToken;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTokenForVerification(Token token) {
        if (token == null) {
            return false;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("addTokenForVerification: trying to acquire synchronized block");
        }
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            try {
                if (this.tokensToProcess.containsKey(token)) {
                    if (traceEnabled) {
                        LOG.trace("Token was already in the list {}:{}", new Object[]{token.getClass().getSimpleName(), token.getAbbreviation()});
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.tokensToProcess.put(token, null);
                if (traceEnabled) {
                    LOG.trace("+ New {} to check: {}", new Object[]{token.getClass().getSimpleName(), token.getAbbreviation()});
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (traceEnabled) {
                    LOG.trace("addTokenForVerification: almost left synchronized block");
                }
            }
        }
    }

    @Override
    public void addRevocationTokensForVerification(List<RevocationToken> revocationTokens) {
        for (RevocationToken revocationToken : revocationTokens) {
            if (!this.addTokenForVerification((Token)revocationToken)) continue;
            boolean added = this.processedRevocations.add(revocationToken);
            if (!LOG.isTraceEnabled()) continue;
            if (added) {
                LOG.trace("RevocationToken added to processedRevocations: {} ", (Object)revocationToken);
                continue;
            }
            LOG.trace("RevocationToken already present processedRevocations: {} ", (Object)revocationToken);
        }
    }

    @Override
    public void addCertificateTokenForVerification(CertificateToken certificateToken) {
        if (this.addTokenForVerification((Token)certificateToken)) {
            boolean added = this.processedCertificates.add(certificateToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("CertificateToken added to processedRevocations: {} ", (Object)certificateToken);
                } else {
                    LOG.trace("CertificateToken already present processedRevocations: {} ", (Object)certificateToken);
                }
            }
        }
    }

    @Override
    public void addTimestampTokenForVerification(TimestampToken timestampToken) {
        if (this.addTokenForVerification(timestampToken)) {
            boolean added = this.processedTimestamps.add(timestampToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("TimestampToken added to processedRevocations: {} ", this.processedTimestamps);
                } else {
                    LOG.trace("TimestampToken already present processedRevocations: {} ", this.processedTimestamps);
                }
            }
        }
    }

    @Override
    public void validate() throws DSSException {
        Token token = null;
        do {
            if ((token = this.getNotYetVerifiedToken()) == null) continue;
            CertificateToken issuerCertToken = this.getIssuerCertificate(token);
            if (issuerCertToken != null) {
                this.addCertificateTokenForVerification(issuerCertToken);
            }
            if (!(token instanceof CertificateToken)) continue;
            List<RevocationToken> revocationTokens = this.getRevocationData((CertificateToken)token);
            this.addRevocationTokensForVerification(revocationTokens);
        } while (token != null);
    }

    private List<RevocationToken> getRevocationData(CertificateToken certToken) {
        OCSPAndCRLCertificateVerifier onlineVerifier;
        RevocationToken onlineRevocationToken;
        RevocationToken crlToken;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checking revocation data for: " + certToken.getDSSIdAsString());
        }
        if (certToken.isSelfSigned() || certToken.isTrusted() || certToken.getIssuerToken() == null) {
            LOG.warn("Revocation data will not be verified because one of the following: token is selfSigned:{} or trusted:{} or hasNoIssuer:{}", new Object[]{certToken.isSelfSigned(), certToken.isTrusted(), certToken.getIssuerToken() == null});
            LOG.warn("Hence no corresponding data will be added to the signature");
            return Collections.emptyList();
        }
        if (DSSASN1Utils.hasIdPkixOcspNoCheckExtension((CertificateToken)certToken)) {
            certToken.extraInfo().infoOCSPNoCheckPresent();
            return Collections.emptyList();
        }
        ArrayList<RevocationToken> revocations = new ArrayList<RevocationToken>();
        OCSPAndCRLCertificateVerifier offlineVerifier = new OCSPAndCRLCertificateVerifier(this.signatureCRLSource, this.signatureOCSPSource, this.validationCertificatePool);
        RevocationToken ocspToken = offlineVerifier.checkOCSP(certToken);
        if (ocspToken != null) {
            revocations.add(ocspToken);
        }
        if ((crlToken = offlineVerifier.checkCRL(certToken)) != null) {
            revocations.add(crlToken);
        }
        if ((onlineRevocationToken = (onlineVerifier = new OCSPAndCRLCertificateVerifier(this.crlSource, this.ocspSource, this.validationCertificatePool)).check(certToken)) != null && !revocations.contains(onlineRevocationToken)) {
            revocations.add(onlineRevocationToken);
        }
        return revocations;
    }

    @Override
    public Set<CertificateToken> getProcessedCertificates() {
        return Collections.unmodifiableSet(this.processedCertificates);
    }

    @Override
    public Set<RevocationToken> getProcessedRevocations() {
        return Collections.unmodifiableSet(this.processedRevocations);
    }

    @Override
    public Set<TimestampToken> getProcessedTimestamps() {
        return Collections.unmodifiableSet(this.processedTimestamps);
    }

    public List<TimestampReference> getTimestampedReferences() {
        return this.timestampedReferences;
    }

    public String toString(String indentStr) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(indentStr).append("ValidationContext[").append('\n');
            indentStr = indentStr + "\t";
            builder.append(indentStr).append("Certificates[").append('\n');
            indentStr = indentStr + "\t";
            for (CertificateToken certToken : this.processedCertificates) {
                builder.append(certToken.toString(indentStr));
            }
            indentStr = indentStr.substring(1);
            builder.append(indentStr).append("],\n");
            indentStr = indentStr.substring(1);
            builder.append(indentStr).append("],\n");
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public String toString() {
        return this.toString("");
    }
}

