/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.TimestampCertificateSource;
import eu.europa.esig.dss.validation.TimestampInclude;
import eu.europa.esig.dss.validation.TimestampReference;
import eu.europa.esig.dss.x509.ArchiveTimestampType;
import eu.europa.esig.dss.x509.CertificatePool;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TimestampType;
import eu.europa.esig.dss.x509.TimestampValidity;
import eu.europa.esig.dss.x509.Token;
import eu.europa.esig.dss.x509.TokenValidationExtraInfo;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampToken
extends Token {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampToken.class);
    private boolean processed = false;
    private final TimeStampToken timeStamp;
    private TimestampType timeStampType;
    private TimestampCertificateSource certificateSource;
    private boolean messageImprintData;
    private Boolean messageImprintIntact = null;
    private List<TimestampReference> timestampedReferences;
    private List<TimestampInclude> timestampIncludes;
    private ArchiveTimestampType archiveTimestampType;
    private String canonicalizationMethod;
    private int hashCode;

    public TimestampToken(byte[] binaries, TimestampType type, CertificatePool certPool) throws TSPException, IOException, CMSException {
        this(new CMSSignedData(binaries), type, certPool);
    }

    public TimestampToken(CMSSignedData cms, TimestampType type, CertificatePool certPool) throws TSPException, IOException {
        this(new TimeStampToken(cms), type, certPool);
    }

    public TimestampToken(TimeStampToken timeStamp, TimestampType type, CertificatePool certPool) {
        this.timeStamp = timeStamp;
        this.timeStampType = type;
        this.extraInfo = new TokenValidationExtraInfo();
        this.certificateSource = new TimestampCertificateSource(timeStamp, certPool);
        List certs = this.certificateSource.getCertificates();
        for (CertificateToken certificateToken : certs) {
            boolean valid;
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)certificateToken);
            if (!timeStamp.getSID().match((Object)x509CertificateHolder) || !(valid = this.isSignedBy(certificateToken))) continue;
            break;
        }
    }

    public String getAbbreviation() {
        return this.timeStampType.name() + ": " + this.getDSSIdAsString() + ": " + DSSUtils.formatInternal((Date)this.timeStamp.getTimeStampInfo().getGenTime());
    }

    public final boolean isSignedBy(CertificateToken issuerToken) {
        if (this.issuerToken != null) {
            return this.issuerToken.equals((Object)issuerToken);
        }
        TimestampValidity timestampValidity = this.validateTimestampToken(this.timeStamp, issuerToken);
        this.signatureInvalidityReason = timestampValidity.name();
        boolean bl = this.signatureValid = TimestampValidity.VALID == timestampValidity;
        if (this.signatureValid) {
            this.issuerToken = issuerToken;
            this.issuerX500Principal = issuerToken.getSubjectX500Principal();
            String algorithm = issuerToken.getPublicKey().getAlgorithm();
            EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm.forName((String)algorithm);
            AlgorithmIdentifier hashAlgorithm = this.timeStamp.getTimeStampInfo().getHashAlgorithm();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID((String)hashAlgorithm.getAlgorithm().getId());
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm((EncryptionAlgorithm)encryptionAlgorithm, (DigestAlgorithm)digestAlgorithm);
        }
        return this.signatureValid;
    }

    private TimestampValidity validateTimestampToken(TimeStampToken timeStampToken, CertificateToken issuerToken) {
        TimestampValidity timestampValidity;
        try {
            JcaSimpleSignerInfoVerifierBuilder verifierBuilder = new JcaSimpleSignerInfoVerifierBuilder();
            X509Certificate x509Certificate = issuerToken.getCertificate();
            SignerInformationVerifier verifier = verifierBuilder.build(x509Certificate);
            timeStampToken.validate(verifier);
            timestampValidity = TimestampValidity.VALID;
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No signing certificate for timestamp token: ", (Throwable)e);
            } else {
                LOG.info("No signing certificate for timestamp token: {}", (Object)e.getMessage());
            }
            timestampValidity = TimestampValidity.NO_SIGNING_CERTIFICATE;
        }
        catch (TSPValidationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No valid signature for timestamp token: ", (Throwable)e);
            } else {
                LOG.info("No valid signature for timestamp token: {}", (Object)e.getMessage());
            }
            timestampValidity = TimestampValidity.NOT_VALID_SIGNATURE;
        }
        catch (TSPException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No valid structure for timestamp token: ", (Throwable)e);
            } else {
                LOG.info("No valid structure for timestamp token: {}", (Object)e.getMessage());
            }
            timestampValidity = TimestampValidity.NOT_VALID_STRUCTURE;
        }
        catch (OperatorCreationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No valid structure for timestamp token: ", (Throwable)e);
            } else {
                LOG.info("No valid structure for timestamp token: {}", (Object)e.getMessage());
            }
            timestampValidity = TimestampValidity.NOT_VALID_STRUCTURE;
        }
        return timestampValidity;
    }

    public boolean matchData(byte[] data) {
        try {
            this.processed = true;
            this.messageImprintData = data != null;
            TimeStampTokenInfo timeStampInfo = this.timeStamp.getTimeStampInfo();
            ASN1ObjectIdentifier hashAlgorithm = timeStampInfo.getHashAlgorithm().getAlgorithm();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID((String)hashAlgorithm.getId());
            byte[] computedDigest = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])data);
            byte[] timestampDigest = timeStampInfo.getMessageImprintDigest();
            this.messageImprintIntact = Arrays.equals(computedDigest, timestampDigest);
            if (!this.messageImprintIntact.booleanValue()) {
                LOG.error("Computed digest ({}) on the extracted data from the document : {}", (Object)digestAlgorithm, (Object)Utils.toHex((byte[])computedDigest));
                LOG.error("Digest present in TimestampToken: {}", (Object)Utils.toHex((byte[])timestampDigest));
                LOG.error("Digest in TimestampToken matches digest of extracted data from document: {}", (Object)this.messageImprintIntact);
            }
        }
        catch (DSSException e) {
            this.messageImprintIntact = false;
        }
        return this.messageImprintIntact;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public TimestampType getTimeStampType() {
        return this.timeStampType;
    }

    public Date getGenerationTime() {
        return this.timeStamp.getTimeStampInfo().getGenTime();
    }

    public DigestAlgorithm getSignedDataDigestAlgo() {
        ASN1ObjectIdentifier oid = this.timeStamp.getTimeStampInfo().getHashAlgorithm().getAlgorithm();
        return DigestAlgorithm.forOID((String)oid.getId());
    }

    public String getEncodedSignedDataDigestValue() {
        byte[] messageImprintDigest = this.timeStamp.getTimeStampInfo().getMessageImprintDigest();
        return Utils.toBase64((byte[])messageImprintDigest);
    }

    public Boolean isMessageImprintDataFound() {
        return this.messageImprintData;
    }

    public Boolean isMessageImprintDataIntact() {
        if (this.messageImprintIntact == null) {
            throw new DSSException("Invoke matchData(byte[] data) method before!");
        }
        return this.messageImprintIntact;
    }

    public List<TimestampReference> getTimestampedReferences() {
        return this.timestampedReferences;
    }

    public void setTimestampedReferences(List<TimestampReference> timestampedReferences) {
        this.timestampedReferences = timestampedReferences;
    }

    public ArchiveTimestampType getArchiveTimestampType() {
        return this.archiveTimestampType;
    }

    public void setArchiveTimestampType(ArchiveTimestampType archiveTimestampType) {
        this.archiveTimestampType = archiveTimestampType;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public byte[] getEncoded() {
        try {
            return this.timeStamp.getEncoded();
        }
        catch (IOException e) {
            throw new DSSException((Throwable)e);
        }
    }

    public List<TimestampInclude> getTimestampIncludes() {
        return this.timestampIncludes;
    }

    public void setTimestampIncludes(List<TimestampInclude> timestampIncludes) {
        this.timestampIncludes = timestampIncludes;
    }

    public List<CertificateToken> getCertificates() {
        return this.certificateSource.getCertificates();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.timeStamp.getUnsignedAttributes();
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public String toString(String indentStr) {
        try {
            StringBuilder out = new StringBuilder();
            out.append(indentStr).append("TimestampToken[signedBy=").append(this.issuerToken == null ? "?" : this.issuerToken.getDSSIdAsString());
            out.append(", generated: ").append(DSSUtils.formatInternal((Date)this.timeStamp.getTimeStampInfo().getGenTime()));
            out.append(" / ").append(this.timeStampType).append('\n');
            if (this.signatureValid) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: VALID").append('\n');
                indentStr = indentStr.substring(1);
            } else if (!this.signatureInvalidityReason.isEmpty()) {
                indentStr = indentStr + "\t";
                out.append(indentStr).append("Timestamp's signature validity: INVALID").append(" - ").append(this.signatureInvalidityReason).append('\n');
                indentStr = indentStr.substring(1);
            }
            indentStr = indentStr + "\t";
            if (this.messageImprintIntact != null) {
                if (this.messageImprintIntact.booleanValue()) {
                    out.append(indentStr).append("Timestamp MATCHES the signed data.").append('\n');
                } else {
                    out.append(indentStr).append("Timestamp DOES NOT MATCH the signed data.").append('\n');
                }
            }
            indentStr = indentStr.substring(1);
            if (this.issuerToken != null) {
                indentStr = indentStr + "\t";
                out.append(this.issuerToken.toString(indentStr)).append('\n');
                indentStr = indentStr.substring(1);
                out.append(indentStr);
            }
            out.append(']');
            return out.toString();
        }
        catch (Exception e) {
            return ((Object)((Object)this)).getClass().getName();
        }
    }
}

