/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X500PrincipalMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(X500PrincipalMatcher.class);
    public static final String DSS_DN_UNESCAPEMULTIBYTEUTF8LITERAL = "dss.dn.unescapemultibyteutf8literal";
    private static boolean APPLY_UNESCAPEMULTIBYTEUTF8LITERAL;

    private X500PrincipalMatcher() {
    }

    public static boolean viaAny(X500Principal p1, X500Principal p2) {
        return X500PrincipalMatcher.viaEquals(p1, p2) || X500PrincipalMatcher.viaName(p1, p2);
    }

    public static boolean viaEquals(X500Principal p1, X500Principal p2) {
        return p1.equals(p2);
    }

    public static boolean viaName(X500Principal p1, X500Principal p2) {
        String cn1 = X500PrincipalMatcher.getCanonicalName(p1);
        String n1 = X500PrincipalMatcher.maybePatchDN(cn1);
        String cn2 = X500PrincipalMatcher.getCanonicalName(p2);
        String n2 = X500PrincipalMatcher.maybePatchDN(cn2);
        return n1.equals(n2);
    }

    private static String getCanonicalName(X500Principal p1) {
        return p1.getName("CANONICAL");
    }

    public static boolean viaAny(X500Name p1, X500Name p2) {
        return X500PrincipalMatcher.viaEquals(p1, p2) || X500PrincipalMatcher.viaName(p1, p2);
    }

    public static boolean viaEquals(X500Name p1, X500Name p2) {
        return p1.equals((Object)p2);
    }

    public static boolean viaName(X500Name p1, X500Name p2) {
        String cn1 = X500PrincipalMatcher.getCanonicalName(p1);
        String n1 = X500PrincipalMatcher.maybePatchDN(cn1);
        String cn2 = X500PrincipalMatcher.getCanonicalName(p2);
        String n2 = X500PrincipalMatcher.maybePatchDN(cn2);
        return n1.equals(n2);
    }

    private static String getCanonicalName(X500Name p1) {
        return p1.toString();
    }

    public static void resolvePatchConfiguration() {
        APPLY_UNESCAPEMULTIBYTEUTF8LITERAL = "true".equalsIgnoreCase(System.getProperty(DSS_DN_UNESCAPEMULTIBYTEUTF8LITERAL, "false"));
    }

    public static void enablePatchDN() {
        System.setProperty(DSS_DN_UNESCAPEMULTIBYTEUTF8LITERAL, "true");
        X500PrincipalMatcher.resolvePatchConfiguration();
    }

    public static String maybePatchDN(String distinguishedName) {
        if (APPLY_UNESCAPEMULTIBYTEUTF8LITERAL) {
            distinguishedName = X500PrincipalMatcher.unescapeMultiByteUtf8Literals(distinguishedName);
        }
        return distinguishedName;
    }

    private static String unescapeMultiByteUtf8Literals(String s) {
        try {
            String q = new String(X500PrincipalMatcher.unescapePython(s.getBytes("UTF-8")), "UTF-8");
            if (!q.equals(s)) {
                LOG.error("multi byte utf literal found:\n  orig = " + s + "\n" + "  escp = " + q);
            }
            return q;
        }
        catch (Exception e) {
            LOG.error("Could not unescape multi byte utf literal - will use original input: " + s, (Throwable)e);
            return s;
        }
    }

    private static byte[] unescapePython(byte[] escaped) throws Exception {
        byte[] unescaped = new byte[escaped.length];
        int posTarget = 0;
        for (int posSource = 0; posSource < escaped.length; ++posSource) {
            if (escaped[posSource] != 92) {
                unescaped[posTarget] = escaped[posSource];
                ++posTarget;
                continue;
            }
            if (posSource + 1 >= escaped.length) {
                throw new Exception("String incorrectly escaped, ends with escape character.");
            }
            if (escaped[posSource + 1] == 120) {
                if (posSource + 3 >= escaped.length) {
                    throw new Exception("String incorrectly escaped, ends early with incorrect hex encoding.");
                }
                unescaped[posTarget] = (byte)((Character.digit(escaped[posSource + 2], 16) << 4) + Character.digit(escaped[posSource + 3], 16));
                ++posTarget;
                posSource += 3;
                continue;
            }
            if (escaped[posSource + 1] == 110) {
                unescaped[posTarget] = 10;
                ++posTarget;
                ++posSource;
                continue;
            }
            if (escaped[posSource + 1] == 116) {
                unescaped[posTarget] = 9;
                ++posTarget;
                ++posSource;
                continue;
            }
            if (escaped[posSource + 1] == 114) {
                unescaped[posTarget] = 13;
                ++posTarget;
                ++posSource;
                continue;
            }
            if (escaped[posSource + 1] == 92) {
                unescaped[posTarget] = escaped[posSource + 1];
                ++posTarget;
                ++posSource;
                continue;
            }
            if (escaped[posSource + 1] == 39) {
                unescaped[posTarget] = escaped[posSource + 1];
                ++posTarget;
                ++posSource;
                continue;
            }
            throw new Exception("String incorrectly escaped, invalid escaped character");
        }
        byte[] result = new byte[posTarget];
        System.arraycopy(unescaped, 0, result, 0, posTarget);
        return result;
    }

    static {
        X500PrincipalMatcher.resolvePatchConfiguration();
    }
}

