/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.BLevelParameters;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignaturePackaging;
import eu.europa.esig.dss.TimestampParameters;
import java.io.Serializable;

public abstract class AbstractSerializableSignatureParameters
implements Serializable {
    private boolean signWithExpiredCertificate = false;
    private SignatureLevel signatureLevel;
    private SignaturePackaging signaturePackaging;
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSA_SHA256;
    private EncryptionAlgorithm encryptionAlgorithm = this.signatureAlgorithm.getEncryptionAlgorithm();
    private DigestAlgorithm digestAlgorithm = this.signatureAlgorithm.getDigestAlgorithm();
    private BLevelParameters bLevelParams = new BLevelParameters();
    private TimestampParameters signatureTimestampParameters;
    private TimestampParameters archiveTimestampParameters;
    private TimestampParameters contentTimestampParameters;

    public boolean isSignWithExpiredCertificate() {
        return this.signWithExpiredCertificate;
    }

    public void setSignWithExpiredCertificate(boolean signWithExpiredCertificate) {
        this.signWithExpiredCertificate = signWithExpiredCertificate;
    }

    public SignatureLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null) {
            throw new NullPointerException("signatureLevel");
        }
        this.signatureLevel = signatureLevel;
    }

    public SignaturePackaging getSignaturePackaging() {
        return this.signaturePackaging;
    }

    public void setSignaturePackaging(SignaturePackaging signaturePackaging) {
        this.signaturePackaging = signaturePackaging;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        if (this.digestAlgorithm != null && this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm(this.encryptionAlgorithm, this.digestAlgorithm);
        }
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        if (this.digestAlgorithm != null && this.encryptionAlgorithm != null) {
            this.signatureAlgorithm = SignatureAlgorithm.getAlgorithm(this.encryptionAlgorithm, this.digestAlgorithm);
        }
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public BLevelParameters bLevel() {
        return this.bLevelParams;
    }

    public BLevelParameters getBLevelParams() {
        return this.bLevelParams;
    }

    public void setBLevelParams(BLevelParameters bLevelParams) {
        this.bLevelParams = bLevelParams;
    }

    public TimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new TimestampParameters();
        }
        return this.signatureTimestampParameters;
    }

    public void setSignatureTimestampParameters(TimestampParameters signatureTimestampParameters) {
        this.signatureTimestampParameters = signatureTimestampParameters;
    }

    public TimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new TimestampParameters();
        }
        return this.archiveTimestampParameters;
    }

    public void setArchiveTimestampParameters(TimestampParameters archiveTimestampParameters) {
        this.archiveTimestampParameters = archiveTimestampParameters;
    }

    public TimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new TimestampParameters();
        }
        return this.contentTimestampParameters;
    }

    public void setContentTimestampParameters(TimestampParameters contentTimestampParameters) {
        this.contentTimestampParameters = contentTimestampParameters;
    }

    public String toString() {
        return "SignatureParameters{signWithExpiredCertificate=" + this.signWithExpiredCertificate + ", signatureLevel=" + (Object)((Object)this.signatureLevel) + ", signaturePackaging=" + (Object)((Object)this.signaturePackaging) + ", signatureAlgorithm=" + (Object)((Object)this.signatureAlgorithm) + ", encryptionAlgorithm=" + (Object)((Object)this.encryptionAlgorithm) + ", digestAlgorithm=" + (Object)((Object)this.digestAlgorithm) + ", bLevelParams=" + this.bLevelParams + ", signatureTimestampParameters=" + (this.signatureTimestampParameters == null ? null : this.signatureTimestampParameters.toString()) + ", archiveTimestampParameters=" + (this.archiveTimestampParameters == null ? null : this.archiveTimestampParameters.toString()) + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.archiveTimestampParameters == null ? 0 : this.archiveTimestampParameters.hashCode());
        result = 31 * result + (this.bLevelParams == null ? 0 : this.bLevelParams.hashCode());
        result = 31 * result + (this.contentTimestampParameters == null ? 0 : this.contentTimestampParameters.hashCode());
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        result = 31 * result + (this.encryptionAlgorithm == null ? 0 : this.encryptionAlgorithm.hashCode());
        result = 31 * result + (this.signWithExpiredCertificate ? 1231 : 1237);
        result = 31 * result + (this.signatureAlgorithm == null ? 0 : this.signatureAlgorithm.hashCode());
        result = 31 * result + (this.signatureLevel == null ? 0 : this.signatureLevel.hashCode());
        result = 31 * result + (this.signaturePackaging == null ? 0 : this.signaturePackaging.hashCode());
        result = 31 * result + (this.signatureTimestampParameters == null ? 0 : this.signatureTimestampParameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSerializableSignatureParameters other = (AbstractSerializableSignatureParameters)obj;
        if (this.archiveTimestampParameters == null ? other.archiveTimestampParameters != null : !this.archiveTimestampParameters.equals(other.archiveTimestampParameters)) {
            return false;
        }
        if (this.bLevelParams == null ? other.bLevelParams != null : !this.bLevelParams.equals(other.bLevelParams)) {
            return false;
        }
        if (this.contentTimestampParameters == null ? other.contentTimestampParameters != null : !this.contentTimestampParameters.equals(other.contentTimestampParameters)) {
            return false;
        }
        if (this.digestAlgorithm != other.digestAlgorithm) {
            return false;
        }
        if (this.encryptionAlgorithm != other.encryptionAlgorithm) {
            return false;
        }
        if (this.signWithExpiredCertificate != other.signWithExpiredCertificate) {
            return false;
        }
        if (this.signatureAlgorithm != other.signatureAlgorithm) {
            return false;
        }
        if (this.signatureLevel != other.signatureLevel) {
            return false;
        }
        if (this.signaturePackaging != other.signaturePackaging) {
            return false;
        }
        return !(this.signatureTimestampParameters == null ? other.signatureTimestampParameters != null : !this.signatureTimestampParameters.equals(other.signatureTimestampParameters));
    }
}

