/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DigestAlgorithm;
import java.io.Serializable;

public class TimestampParameters
implements Serializable {
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA256;
    private String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm == null) {
            throw new NullPointerException();
        }
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        if (canonicalizationMethod == null || canonicalizationMethod.isEmpty()) {
            throw new NullPointerException();
        }
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.canonicalizationMethod == null ? 0 : this.canonicalizationMethod.hashCode());
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampParameters other = (TimestampParameters)obj;
        if (this.canonicalizationMethod == null ? other.canonicalizationMethod != null : !this.canonicalizationMethod.equals(other.canonicalizationMethod)) {
            return false;
        }
        return this.digestAlgorithm == other.digestAlgorithm;
    }

    public String toString() {
        return "TimestampParameters{, digestAlgorithm=" + this.digestAlgorithm.getName() + ", canonicalizationMethod=" + this.canonicalizationMethod + "}";
    }
}

