/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TokenValidationExtraInfo;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public abstract class Token
implements Serializable {
    private String dssId;
    protected CertificateToken issuerToken;
    protected X500Principal issuerX500Principal;
    protected boolean signatureValid = false;
    protected String signatureInvalidityReason = "";
    protected SignatureAlgorithm signatureAlgorithm;
    protected TokenValidationExtraInfo extraInfo;
    private TokenIdentifier tokenIdentifier;
    private Map<DigestAlgorithm, byte[]> digests = new HashMap<DigestAlgorithm, byte[]>();

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Token)) {
            return false;
        }
        Token o2 = (Token)obj;
        return this.getDSSId().equals(o2.getDSSId());
    }

    public final int hashCode() {
        return this.getDSSId().hashCode();
    }

    public boolean isTrusted() {
        return false;
    }

    public boolean isSelfSigned() {
        return false;
    }

    public TokenIdentifier getDSSId() {
        if (this.tokenIdentifier == null) {
            this.tokenIdentifier = new TokenIdentifier(this);
        }
        return this.tokenIdentifier;
    }

    public String getDSSIdAsString() {
        if (this.dssId == null) {
            this.dssId = this.getDSSId().asXmlId();
        }
        return this.dssId;
    }

    public X500Principal getIssuerX500Principal() {
        return this.issuerX500Principal;
    }

    public CertificateToken getIssuerToken() {
        return this.issuerToken;
    }

    public abstract boolean isSignedBy(CertificateToken var1);

    public List<String> getValidationInfo() {
        return this.extraInfo.getValidationInfo();
    }

    public String getAbbreviation() {
        return "?";
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public boolean isSignatureValid() {
        return this.isTrusted() || this.signatureValid;
    }

    public TokenValidationExtraInfo extraInfo() {
        return this.extraInfo;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    public abstract byte[] getEncoded();

    public byte[] getDigest(DigestAlgorithm digestAlgorithm) {
        byte[] digestValue = this.digests.get((Object)digestAlgorithm);
        if (digestValue == null) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm.getJavaName());
                digestValue = md.digest(this.getEncoded());
                this.digests.put(digestAlgorithm, digestValue);
            }
            catch (Exception e) {
                throw new DSSException("Unable to compute digest with algo " + (Object)((Object)digestAlgorithm), e);
            }
        }
        return digestValue;
    }
}

