/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.spi.DSSUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;

class PdfBoxArray
implements PdfArray {
    private COSArray wrapped;
    private PDDocument document;

    public PdfBoxArray(COSArray wrapped, PDDocument document) {
        this.wrapped = wrapped;
        this.document = document;
    }

    public int size() {
        return this.wrapped.size();
    }

    public byte[] getBytes(int i) throws IOException {
        COSBase val = this.wrapped.get(i);
        return this.toBytes(val);
    }

    public long getObjectNumber(int i) {
        COSObject cosObject = (COSObject)this.wrapped.get(i);
        return cosObject.getObjectNumber();
    }

    public int getInt(int i) throws IOException {
        return this.wrapped.getInt(i);
    }

    private byte[] toBytes(COSBase val) throws IOException {
        COSObject o;
        COSBase object;
        COSStream cosStream = null;
        if (val instanceof COSObject && (object = (o = (COSObject)val).getObject()) instanceof COSStream) {
            cosStream = (COSStream)object;
        }
        if (cosStream == null) {
            throw new RuntimeException("Cannot find value for " + val + " of class " + val.getClass());
        }
        return DSSUtils.toByteArray((InputStream)cosStream.createInputStream());
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

