/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSReference;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.net.URLEncoder;
import org.digidoc4j.dss.xades.BDocTmSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DetachedSignatureBuilder
extends XAdESSignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DetachedSignatureBuilder.class);

    public DetachedSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
        this.setCanonicalizationMethods(params, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    @Override
    protected Document buildRootDocumentDom() {
        if (this.params.getRootDocument() != null) {
            return this.params.getRootDocument();
        }
        return DomUtils.buildDOM();
    }

    @Override
    protected Node getParentNodeOfSignature() {
        if (this.params.getRootDocument() != null) {
            return this.documentDom.getDocumentElement();
        }
        return this.documentDom;
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        DSSReference reference = new DSSReference();
        reference.setId("r-id-" + referenceIndex);
        String fileURI = document.getName() != null ? document.getName() : "";
        try {
            String urlEncoded = BDocTmSupport.uriEncode(fileURI);
            reference.setUri(URLEncoder.encode(fileURI, "UTF-8"));
        }
        catch (Exception e) {
            LOG.warn("Unable to encode uri '" + fileURI + "' : " + e.getMessage());
            reference.setUri(fileURI);
        }
        reference.setContents(document);
        reference.setDigestMethodAlgorithm(this.params.getDigestAlgorithm());
        return reference;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        return reference.getContents();
    }
}

