/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ExtensionBuilder
extends XAdESBuilder {
    protected XAdESSignature xadesSignature;
    protected Element currentSignatureDom;
    protected Element qualifyingPropertiesDom;
    protected Element unsignedPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedDataObjectPropertiesDom;

    protected ExtensionBuilder(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    protected void ensureUnsignedProperties() throws DSSException {
        NodeList qualifyingPropertiesNodeList = this.currentSignatureDom.getElementsByTagNameNS(XAdESNamespaces.XAdES, "QualifyingProperties");
        if (qualifyingPropertiesNodeList.getLength() != 1) {
            throw new DSSException("The signature does not contain QualifyingProperties element (or contains more than one)! Extension is not possible.");
        }
        this.qualifyingPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        NodeList unsignedPropertiesNodeList = this.currentSignatureDom.getElementsByTagNameNS(XAdESNamespaces.XAdES, "UnsignedProperties");
        int length = unsignedPropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedPropertiesDom = (Element)qualifyingPropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedPropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.qualifyingPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:UnsignedProperties");
        } else {
            throw new DSSException("The signature contains more then one UnsignedProperties element! Extension is not possible.");
        }
    }

    protected void ensureUnsignedSignatureProperties() throws DSSException {
        NodeList unsignedSignaturePropertiesNodeList = this.currentSignatureDom.getElementsByTagNameNS(XAdESNamespaces.XAdES, "UnsignedSignatureProperties");
        int length = unsignedSignaturePropertiesNodeList.getLength();
        if (length == 1) {
            this.unsignedSignaturePropertiesDom = (Element)unsignedSignaturePropertiesNodeList.item(0);
        } else if (length == 0) {
            this.unsignedSignaturePropertiesDom = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedPropertiesDom, (String)XAdESNamespaces.XAdES, (String)"xades:UnsignedSignatureProperties");
        } else {
            throw new DSSException("The signature contains more then one UnsignedSignatureProperties element! Extension is not possible.");
        }
    }

    protected void ensureSignedDataObjectProperties() throws DSSException {
        NodeList signedDataObjectPropertiesNodeList = this.currentSignatureDom.getElementsByTagNameNS(XAdESNamespaces.XAdES, "SignedDataObjectProperties");
        int length = signedDataObjectPropertiesNodeList.getLength();
        if (length == 1) {
            this.signedDataObjectPropertiesDom = (Element)signedDataObjectPropertiesNodeList.item(0);
        } else if (length > 1) {
            throw new DSSException("The signature contains more than one SignedDataObjectProperties element! Extension is not possible.");
        }
    }
}

