/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.crl.CRLToken;
import eu.europa.esig.dss.x509.ocsp.OCSPToken;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLT
extends XAdESLevelBaselineT
implements Serializable {
    public XAdESLevelBaselineLT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        this.assertExtendSignaturePossible();
        super.extendSignatureTag();
        if (this.xadesSignature.hasLTAProfile()) {
            return;
        }
        this.checkSignatureIntegrity();
        ValidationContext valContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
        this.removeOldCertificateValues();
        this.removeOldRevocationValues();
        List<CertificateToken> toIncludeCertificates = this.getToIncludeCertificateTokens(valContext);
        this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, toIncludeCertificates);
        this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, valContext);
        this.xadesSignature.resetCertificateSource();
        this.xadesSignature.resetRevocationSources();
    }

    protected void checkSignatureIntegrity() throws DSSException {
        SignatureCryptographicVerification signatureCryptographicVerification = this.xadesSignature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureIntact()) {
            String errorMessage = signatureCryptographicVerification.getErrorMessage();
            throw new DSSException("Cryptographic signature verification has failed" + (errorMessage.isEmpty() ? "." : " / " + errorMessage));
        }
    }

    private void removeOldRevocationValues() {
        Element toRemove = this.xadesSignature.getRevocationValues();
        if (toRemove != null) {
            this.unsignedSignaturePropertiesDom.removeChild(toRemove);
            this.xadesSignature.resetRevocationSources();
        }
    }

    private void removeOldCertificateValues() {
        Element toRemove = this.xadesSignature.getCertificateValues();
        if (toRemove != null) {
            this.unsignedSignaturePropertiesDom.removeChild(toRemove);
            this.xadesSignature.resetCertificateSource();
        }
    }

    protected void incorporateRevocationValues(Element parentDom, ValidationContext validationContext) {
        DefaultAdvancedSignature.RevocationDataForInclusion revocationsForInclusion = this.xadesSignature.getRevocationDataForInclusion(validationContext);
        if (!revocationsForInclusion.isEmpty()) {
            Element revocationValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)XAdESNamespaces.XAdES, (String)"xades:RevocationValues");
            this.incorporateCrlTokens(revocationValuesDom, revocationsForInclusion.crlTokens);
            this.incorporateOcspTokens(revocationValuesDom, revocationsForInclusion.ocspTokens);
        }
    }

    private void incorporateCrlTokens(Element parentDom, List<CRLToken> crlTokens) {
        if (crlTokens.isEmpty()) {
            return;
        }
        Element crlValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)XAdESNamespaces.XAdES, (String)"xades:CRLValues");
        for (RevocationToken revocationToken : crlTokens) {
            byte[] encodedCRL = revocationToken.getEncoded();
            String base64EncodedCRL = Utils.toBase64((byte[])encodedCRL);
            DomUtils.addTextElement((Document)this.documentDom, (Element)crlValuesDom, (String)XAdESNamespaces.XAdES, (String)"xades:EncapsulatedCRLValue", (String)base64EncodedCRL);
        }
    }

    private void incorporateOcspTokens(Element parentDom, List<OCSPToken> ocspTokens) {
        if (ocspTokens.isEmpty()) {
            return;
        }
        Element ocspValuesDom = DomUtils.addElement((Document)this.documentDom, (Element)parentDom, (String)XAdESNamespaces.XAdES, (String)"xades:OCSPValues");
        for (RevocationToken revocationToken : ocspTokens) {
            byte[] encodedOCSP = revocationToken.getEncoded();
            String base64EncodedOCSP = Utils.toBase64((byte[])encodedOCSP);
            DomUtils.addTextElement((Document)this.documentDom, (Element)ocspValuesDom, (String)XAdESNamespaces.XAdES, (String)"xades:EncapsulatedOCSPValue", (String)base64EncodedOCSP);
        }
    }

    private void assertExtendSignaturePossible() throws DSSException {
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (SignatureLevel.XAdES_BASELINE_LT.equals((Object)signatureLevel) && this.xadesSignature.hasLTAProfile()) {
            String exceptionMessage = "Cannot extend signature. The signedData is already extended with [%s].";
            throw new DSSException(String.format("Cannot extend signature. The signedData is already extended with [%s].", "XAdES LTA"));
        }
    }
}

