/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.dss.xades;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.Policy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XPathQueryHolder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BDocTmSupport
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(BDocTmSupport.class);
    public static final String BDOC_TM_POLICY_ID = "urn:oid:1.3.6.1.4.1.10015.1000.3.2.1";
    public static final String BDOC_TM_POLICY_QUALIFIER = "OIDAsURN";

    public static boolean isBdocTmSignatureProfile(XAdESSignatureParameters params) {
        Policy signaturePolicy = params.bLevel().getSignaturePolicy();
        if (signaturePolicy == null) {
            return false;
        }
        String policyId = Utils.trim((String)signaturePolicy.getId());
        return BDOC_TM_POLICY_ID.equals(policyId);
    }

    public static boolean hasBDocTmPolicyId(Element signatureElement, XPathQueryHolder xPathQueryHolder) {
        Element policyId;
        Element policyIdentifier = DomUtils.getElement((Node)signatureElement, (String)xPathQueryHolder.XPATH_SIGNATURE_POLICY_IDENTIFIER);
        if (policyIdentifier != null && (policyId = DomUtils.getElement((Node)policyIdentifier, (String)xPathQueryHolder.XPATH__POLICY_ID)) != null) {
            String policyIdString = Utils.trim((String)policyId.getTextContent());
            return Utils.areStringsEqualIgnoreCase((String)BDOC_TM_POLICY_ID, (String)policyIdString);
        }
        return false;
    }

    public static String uriEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to decode '" + string + "' : " + e.getMessage(), (Throwable)e);
            return string;
        }
    }

    public static String fixEncoding(String string) {
        return string.replaceAll("\\+", "%2B");
    }
}

