/*
 * Copyright 2005 Joe Walker
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.directwebremoting.util;

/**
 * Man this is embarrassing.
 * @author Joe Walker [joe at getahead dot ltd dot uk]
 */
@SuppressWarnings({"ClassEscapesDefinedScope"})
public class Pair<A, B>
{
    public final A left;

    public final B right;

    public Pair(A left, B right)
    {
        this.left = left;
        this.right = right;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj)
    {

        if (obj == null || (!this.getClass().equals(obj.getClass())))
        {
            return false;
        }

        if (obj == this)
        {
            return true;
        }

        @SuppressWarnings("unchecked")
        Pair<A, B> that = (Pair<A, B>) obj;

        if (!LocalUtil.equals(this.left, that.left))
        {
            return false;
        }

        if (!LocalUtil.equals(this.right, that.right))
        {
            return false;
        }

        return true;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode()
    {
        int hash = 24;
        hash += (left != null) ? left.hashCode() : 432;
        hash += (right != null) ? right.hashCode() : 635;
        return hash;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return "[" + left + ":" + right + "]";
    }
}
