/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.util.List;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerParseTest {
    private final String PNG_IMAGE_DATA = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC";
    private WordprocessingMLPackage wordMLPackage;

    @Before
    public void setup() throws Exception {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    private List<Object> convert(String xhtml) throws Docx4JException {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        return XHTMLImporter2.convert(xhtml, "");
    }

    @Test
    public void testParagraphInParagraphLayout() throws Exception {
        String html = "<p><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><p><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/></p><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/></p>";
        List<Object> convert = this.convert(html);
        Assert.assertTrue((convert.size() == 3 ? 1 : 0) != 0);
        for (Object o : convert) {
            Assert.assertTrue((boolean)(o instanceof P));
            P paragraph = (P)o;
            List content = paragraph.getContent();
            Assert.assertTrue((content.size() == 2 ? 1 : 0) != 0);
            for (Object child : content) {
                Assert.assertTrue((boolean)(child instanceof R));
                R run = (R)child;
                List rContent = run.getContent();
                Assert.assertTrue((rContent.size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(rContent.get(0) instanceof Drawing));
            }
        }
    }

    @Test
    public void testParagraphInTableCellLayout() throws Exception {
        String html = "<table><tbody><tr><td><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><p><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/></p><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/><img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAACAgMAAAAP2OW3AAAADFBMVEUDAP//AAAA/wb//AAD4Tw1AAAACXBIWXMAAAsTAAALEwEAmpwYAAAADElEQVQI12NwYNgAAAF0APHJnpmVAAAAAElFTkSuQmCC' height='16' width='19'/></td></tr></tbody></table>";
        List<Object> tConvert = this.convert(html);
        Assert.assertTrue((tConvert.size() == 1 ? 1 : 0) != 0);
        for (Object t : tConvert) {
            Assert.assertTrue((boolean)(t instanceof Tbl));
            Tbl table = (Tbl)t;
            List convert = ((Tc)((Tr)table.getContent().get(0)).getContent().get(0)).getContent();
            Assert.assertTrue((convert.size() == 3 ? 1 : 0) != 0);
            for (Object o : convert) {
                Assert.assertTrue((boolean)(o instanceof P));
                P paragraph = (P)o;
                List content = paragraph.getContent();
                Assert.assertTrue((content.size() == 2 ? 1 : 0) != 0);
                for (Object child : content) {
                    Assert.assertTrue((boolean)(child instanceof R));
                    R run = (R)child;
                    List rContent = run.getContent();
                    Assert.assertTrue((rContent.size() == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)(rContent.get(0) instanceof Drawing));
                }
            }
        }
    }

    @Test
    public void testCenteredTableContainingParagraph() throws Exception {
        String html = "<table align=\"center\"><tbody><tr><td><p> </p></td></tr></tbody></table>";
        List<Object> tConvert = this.convert(html);
        Assert.assertTrue((tConvert.size() == 1 ? 1 : 0) != 0);
    }
}

