/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.math.BigInteger;
import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.FormattingOption;
import org.docx4j.convert.in.xhtml.XHTMLImporterImpl;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTLongHexNumber;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.NumFmt;
import org.docx4j.wml.NumberFormat;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberingTest {
    private WordprocessingMLPackage wordMLPackage;
    private static int PREDEFINED_OL_ABSTRACT_NUMID = 10;
    private static int PREDEFINED_OL_NUMID = 11;

    @Before
    public void setup() throws InvalidFormatException {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
    }

    private List<Object> convert(String xhtml, FormattingOption paragraphFormattingOption) throws Docx4JException {
        XHTMLImporterImpl XHTMLImporter2 = new XHTMLImporterImpl(this.wordMLPackage);
        XHTMLImporter2.setParagraphFormatting(paragraphFormattingOption);
        return XHTMLImporter2.convert(xhtml, "");
    }

    @Test
    public void testUnorderedWithStylePresent() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul class=\"MyListStyle\"><li>List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.CLASS_TO_STYLE_ONLY);
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() == PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getInd() == null ? 1 : 0) != 0);
    }

    @Test
    public void testUnorderedWithStyleOnlyAndAbsent() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul class=\"My_MISSING_ListStyle\"><li>List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.CLASS_TO_STYLE_ONLY);
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr() == null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getInd() == null ? 1 : 0) != 0);
    }

    @Test
    public void testUnorderedWithStyleAbsent() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul class=\"My_MISSING_ListStyle\"><li>List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.CLASS_PLUS_OTHER);
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
    }

    @Test
    public void testUnorderedIgnoreClass() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul class=\"MyListStyle\"><li>List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.IGNORE_CLASS);
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
    }

    @Ignore
    public void testUnorderedCssOnLiToIndent() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul><li style=\"margin-left: 1in;\">List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.IGNORE_CLASS);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart().initialiseMaps();
        PPrBase.Ind ind = this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart().getInd(p.getPPr().getNumPr());
        System.out.println(XmlUtils.marshaltoString((Object)ind));
        Assert.assertTrue((ind.getLeft().intValue() == 2400 ? 1 : 0) != 0);
    }

    @Test
    public void testUnorderedCssOnUlToIndent() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul style=\"margin-left: 0.5in;\"><li>List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.IGNORE_CLASS);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart().initialiseMaps();
        PPrBase.Ind ind = this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart().getInd(p.getPPr().getNumPr());
        Assert.assertTrue((ind.getLeft().intValue() == 1680 ? 1 : 0) != 0);
    }

    @Test
    public void testUnorderedCssDefaultIndentUnset() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul><li>List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.IGNORE_CLASS);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getInd() == null ? 1 : 0) != 0);
    }

    @Test
    public void testUnorderedCssDefaultIndentFalsePositive() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul style=\"margin-left: 0in;\"><li>List item one</li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.IGNORE_CLASS);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(0);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getInd() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNestedNoClass() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul><li>List item two with subitems:<ul><li>Subitem 1</li></ul></li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.IGNORE_CLASS);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(1);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl().getVal().intValue() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getInd() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNestedNoClassButExplicitIndent() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul><li>List item two with subitems:<ul  style=\"margin-left: 2in;\"><li>Subitem 1</li></ul></li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.IGNORE_CLASS);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(1);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl().getVal().intValue() == 1 ? 1 : 0) != 0);
        this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart().initialiseMaps();
        PPrBase.Ind ind = this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart().getInd(p.getPPr().getNumPr());
        Assert.assertTrue((ind.getLeft().intValue() == 4440 ? 1 : 0) != 0);
    }

    @Test
    public void testNestedWithClass() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul><li>List item two with subitems:<ul class=\"MyListStyle\"><li>Subitem 1</li></ul></li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.CLASS_PLUS_OTHER);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(1);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() == PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl().getVal().intValue() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getInd() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNestedWithNoClassOnLevel() throws Docx4JException {
        this.addNumberingPart(this.wordMLPackage.getMainDocumentPart());
        this.addStylesPart(this.wordMLPackage.getMainDocumentPart());
        String xhtml = "<div><ul class=\"MyListStyle\"><li>List item two with subitems:<ul ><li>Subitem 1</li></ul></li></ul></div>";
        List<Object> results = this.convert(xhtml, FormattingOption.CLASS_PLUS_OTHER);
        this.wordMLPackage.getMainDocumentPart().getContent().addAll(results);
        System.out.println(XmlUtils.marshaltoString((Object)this.wordMLPackage.getMainDocumentPart().getJaxbElement(), (boolean)true, (boolean)true));
        P p = (P)results.get(1);
        Assert.assertTrue((p.getPPr().getNumPr() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getNumId().getVal().intValue() != PREDEFINED_OL_NUMID ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl() != null ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getNumPr().getIlvl().getVal().intValue() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((p.getPPr().getInd() == null ? 1 : 0) != 0);
    }

    private void addStylesPart(MainDocumentPart mdp) throws InvalidFormatException {
        StyleDefinitionsPart sdp = new StyleDefinitionsPart();
        mdp.addTargetPart((Part)sdp);
        sdp.setJaxbElement(this.getStyles());
    }

    public Styles getStyles() {
        ObjectFactory wmlObjectFactory = new ObjectFactory();
        Styles styles = wmlObjectFactory.createStyles();
        Style style = wmlObjectFactory.createStyle();
        styles.getStyle().add(style);
        style.setStyleId("MyListStyle");
        PPr ppr = wmlObjectFactory.createPPr();
        style.setPPr(ppr);
        PPrBase.NumPr pprbasenumpr = wmlObjectFactory.createPPrBaseNumPr();
        ppr.setNumPr(pprbasenumpr);
        PPrBase.NumPr.NumId pprbasenumprnumid = wmlObjectFactory.createPPrBaseNumPrNumId();
        pprbasenumpr.setNumId(pprbasenumprnumid);
        pprbasenumprnumid.setVal(BigInteger.valueOf(PREDEFINED_OL_NUMID));
        Style.UiPriority styleuipriority = wmlObjectFactory.createStyleUiPriority();
        style.setUiPriority(styleuipriority);
        styleuipriority.setVal(BigInteger.valueOf(99L));
        Style.Name stylename = wmlObjectFactory.createStyleName();
        style.setName(stylename);
        stylename.setVal("MyListStyle");
        style.setType("numbering");
        styles.getStyle().add(this.createNormal());
        return styles;
    }

    public Style createNormal() {
        ObjectFactory wmlObjectFactory = new ObjectFactory();
        Style style = wmlObjectFactory.createStyle();
        style.setStyleId("Normal");
        BooleanDefaultTrue booleandefaulttrue = wmlObjectFactory.createBooleanDefaultTrue();
        style.setQFormat(booleandefaulttrue);
        Style.Name stylename = wmlObjectFactory.createStyleName();
        style.setName(stylename);
        stylename.setVal("Normal");
        style.setType("paragraph");
        style.setDefault(Boolean.valueOf(true));
        return style;
    }

    private void addNumberingPart(MainDocumentPart mdp) throws InvalidFormatException {
        NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
        mdp.addTargetPart((Part)ndp);
        ndp.setJaxbElement((Object)this.getNumbering());
    }

    public Numbering getNumbering() {
        ObjectFactory wmlObjectFactory = new ObjectFactory();
        Numbering numbering = wmlObjectFactory.createNumbering();
        Numbering.Num numberingnum = wmlObjectFactory.createNumberingNum();
        numbering.getNum().add(numberingnum);
        numberingnum.setNumId(BigInteger.valueOf(PREDEFINED_OL_NUMID));
        Numbering.Num.AbstractNumId numberingnumabstractnumid = wmlObjectFactory.createNumberingNumAbstractNumId();
        numberingnum.setAbstractNumId(numberingnumabstractnumid);
        numberingnumabstractnumid.setVal(BigInteger.valueOf(PREDEFINED_OL_ABSTRACT_NUMID));
        Numbering.AbstractNum numberingabstractnum = wmlObjectFactory.createNumberingAbstractNum();
        numbering.getAbstractNum().add(numberingabstractnum);
        numberingabstractnum.setAbstractNumId(BigInteger.valueOf(PREDEFINED_OL_ABSTRACT_NUMID));
        Lvl lvl = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl);
        lvl.setIlvl(BigInteger.valueOf(0L));
        PPr ppr = wmlObjectFactory.createPPr();
        lvl.setPPr(ppr);
        PPrBase.Ind pprbaseind = wmlObjectFactory.createPPrBaseInd();
        ppr.setInd(pprbaseind);
        pprbaseind.setLeft(BigInteger.valueOf(720L));
        pprbaseind.setHanging(BigInteger.valueOf(360L));
        RPr rpr = wmlObjectFactory.createRPr();
        lvl.setRPr(rpr);
        RFonts rfonts = wmlObjectFactory.createRFonts();
        rpr.setRFonts(rfonts);
        rfonts.setAscii("Symbol");
        rfonts.setHint(STHint.DEFAULT);
        rfonts.setHAnsi("Symbol");
        NumFmt numfmt = wmlObjectFactory.createNumFmt();
        lvl.setNumFmt(numfmt);
        numfmt.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext = wmlObjectFactory.createLvlLvlText();
        lvl.setLvlText(lvllvltext);
        lvllvltext.setVal("\uf0b7");
        Jc jc = wmlObjectFactory.createJc();
        lvl.setLvlJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart = wmlObjectFactory.createLvlStart();
        lvl.setStart(lvlstart);
        lvlstart.setVal(BigInteger.valueOf(1L));
        Lvl lvl2 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl2);
        lvl2.setIlvl(BigInteger.valueOf(1L));
        PPr ppr2 = wmlObjectFactory.createPPr();
        lvl2.setPPr(ppr2);
        PPrBase.Ind pprbaseind2 = wmlObjectFactory.createPPrBaseInd();
        ppr2.setInd(pprbaseind2);
        pprbaseind2.setLeft(BigInteger.valueOf(1440L));
        pprbaseind2.setHanging(BigInteger.valueOf(360L));
        RPr rpr2 = wmlObjectFactory.createRPr();
        lvl2.setRPr(rpr2);
        RFonts rfonts2 = wmlObjectFactory.createRFonts();
        rpr2.setRFonts(rfonts2);
        rfonts2.setAscii("Courier New");
        rfonts2.setHint(STHint.DEFAULT);
        rfonts2.setHAnsi("Courier New");
        rfonts2.setCs("Courier New");
        NumFmt numfmt2 = wmlObjectFactory.createNumFmt();
        lvl2.setNumFmt(numfmt2);
        numfmt2.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext2 = wmlObjectFactory.createLvlLvlText();
        lvl2.setLvlText(lvllvltext2);
        lvllvltext2.setVal("o");
        Jc jc2 = wmlObjectFactory.createJc();
        lvl2.setLvlJc(jc2);
        jc2.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart2 = wmlObjectFactory.createLvlStart();
        lvl2.setStart(lvlstart2);
        lvlstart2.setVal(BigInteger.valueOf(1L));
        Lvl lvl3 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl3);
        lvl3.setIlvl(BigInteger.valueOf(2L));
        PPr ppr3 = wmlObjectFactory.createPPr();
        lvl3.setPPr(ppr3);
        PPrBase.Ind pprbaseind3 = wmlObjectFactory.createPPrBaseInd();
        ppr3.setInd(pprbaseind3);
        pprbaseind3.setLeft(BigInteger.valueOf(2160L));
        pprbaseind3.setHanging(BigInteger.valueOf(360L));
        RPr rpr3 = wmlObjectFactory.createRPr();
        lvl3.setRPr(rpr3);
        RFonts rfonts3 = wmlObjectFactory.createRFonts();
        rpr3.setRFonts(rfonts3);
        rfonts3.setAscii("Wingdings");
        rfonts3.setHint(STHint.DEFAULT);
        rfonts3.setHAnsi("Wingdings");
        NumFmt numfmt3 = wmlObjectFactory.createNumFmt();
        lvl3.setNumFmt(numfmt3);
        numfmt3.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext3 = wmlObjectFactory.createLvlLvlText();
        lvl3.setLvlText(lvllvltext3);
        lvllvltext3.setVal("\uf0a7");
        Jc jc3 = wmlObjectFactory.createJc();
        lvl3.setLvlJc(jc3);
        jc3.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart3 = wmlObjectFactory.createLvlStart();
        lvl3.setStart(lvlstart3);
        lvlstart3.setVal(BigInteger.valueOf(1L));
        Lvl lvl4 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl4);
        lvl4.setIlvl(BigInteger.valueOf(3L));
        PPr ppr4 = wmlObjectFactory.createPPr();
        lvl4.setPPr(ppr4);
        PPrBase.Ind pprbaseind4 = wmlObjectFactory.createPPrBaseInd();
        ppr4.setInd(pprbaseind4);
        pprbaseind4.setLeft(BigInteger.valueOf(2880L));
        pprbaseind4.setHanging(BigInteger.valueOf(360L));
        RPr rpr4 = wmlObjectFactory.createRPr();
        lvl4.setRPr(rpr4);
        RFonts rfonts4 = wmlObjectFactory.createRFonts();
        rpr4.setRFonts(rfonts4);
        rfonts4.setAscii("Symbol");
        rfonts4.setHint(STHint.DEFAULT);
        rfonts4.setHAnsi("Symbol");
        NumFmt numfmt4 = wmlObjectFactory.createNumFmt();
        lvl4.setNumFmt(numfmt4);
        numfmt4.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext4 = wmlObjectFactory.createLvlLvlText();
        lvl4.setLvlText(lvllvltext4);
        lvllvltext4.setVal("\uf0b7");
        Jc jc4 = wmlObjectFactory.createJc();
        lvl4.setLvlJc(jc4);
        jc4.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart4 = wmlObjectFactory.createLvlStart();
        lvl4.setStart(lvlstart4);
        lvlstart4.setVal(BigInteger.valueOf(1L));
        Lvl lvl5 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl5);
        lvl5.setIlvl(BigInteger.valueOf(4L));
        PPr ppr5 = wmlObjectFactory.createPPr();
        lvl5.setPPr(ppr5);
        PPrBase.Ind pprbaseind5 = wmlObjectFactory.createPPrBaseInd();
        ppr5.setInd(pprbaseind5);
        pprbaseind5.setLeft(BigInteger.valueOf(3600L));
        pprbaseind5.setHanging(BigInteger.valueOf(360L));
        RPr rpr5 = wmlObjectFactory.createRPr();
        lvl5.setRPr(rpr5);
        RFonts rfonts5 = wmlObjectFactory.createRFonts();
        rpr5.setRFonts(rfonts5);
        rfonts5.setAscii("Courier New");
        rfonts5.setHint(STHint.DEFAULT);
        rfonts5.setHAnsi("Courier New");
        rfonts5.setCs("Courier New");
        NumFmt numfmt5 = wmlObjectFactory.createNumFmt();
        lvl5.setNumFmt(numfmt5);
        numfmt5.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext5 = wmlObjectFactory.createLvlLvlText();
        lvl5.setLvlText(lvllvltext5);
        lvllvltext5.setVal("o");
        Jc jc5 = wmlObjectFactory.createJc();
        lvl5.setLvlJc(jc5);
        jc5.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart5 = wmlObjectFactory.createLvlStart();
        lvl5.setStart(lvlstart5);
        lvlstart5.setVal(BigInteger.valueOf(1L));
        Lvl lvl6 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl6);
        lvl6.setIlvl(BigInteger.valueOf(5L));
        PPr ppr6 = wmlObjectFactory.createPPr();
        lvl6.setPPr(ppr6);
        PPrBase.Ind pprbaseind6 = wmlObjectFactory.createPPrBaseInd();
        ppr6.setInd(pprbaseind6);
        pprbaseind6.setLeft(BigInteger.valueOf(4320L));
        pprbaseind6.setHanging(BigInteger.valueOf(360L));
        RPr rpr6 = wmlObjectFactory.createRPr();
        lvl6.setRPr(rpr6);
        RFonts rfonts6 = wmlObjectFactory.createRFonts();
        rpr6.setRFonts(rfonts6);
        rfonts6.setAscii("Wingdings");
        rfonts6.setHint(STHint.DEFAULT);
        rfonts6.setHAnsi("Wingdings");
        NumFmt numfmt6 = wmlObjectFactory.createNumFmt();
        lvl6.setNumFmt(numfmt6);
        numfmt6.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext6 = wmlObjectFactory.createLvlLvlText();
        lvl6.setLvlText(lvllvltext6);
        lvllvltext6.setVal("\uf0a7");
        Jc jc6 = wmlObjectFactory.createJc();
        lvl6.setLvlJc(jc6);
        jc6.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart6 = wmlObjectFactory.createLvlStart();
        lvl6.setStart(lvlstart6);
        lvlstart6.setVal(BigInteger.valueOf(1L));
        Lvl lvl7 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl7);
        lvl7.setIlvl(BigInteger.valueOf(6L));
        PPr ppr7 = wmlObjectFactory.createPPr();
        lvl7.setPPr(ppr7);
        PPrBase.Ind pprbaseind7 = wmlObjectFactory.createPPrBaseInd();
        ppr7.setInd(pprbaseind7);
        pprbaseind7.setLeft(BigInteger.valueOf(5040L));
        pprbaseind7.setHanging(BigInteger.valueOf(360L));
        RPr rpr7 = wmlObjectFactory.createRPr();
        lvl7.setRPr(rpr7);
        RFonts rfonts7 = wmlObjectFactory.createRFonts();
        rpr7.setRFonts(rfonts7);
        rfonts7.setAscii("Symbol");
        rfonts7.setHint(STHint.DEFAULT);
        rfonts7.setHAnsi("Symbol");
        NumFmt numfmt7 = wmlObjectFactory.createNumFmt();
        lvl7.setNumFmt(numfmt7);
        numfmt7.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext7 = wmlObjectFactory.createLvlLvlText();
        lvl7.setLvlText(lvllvltext7);
        lvllvltext7.setVal("\uf0b7");
        Jc jc7 = wmlObjectFactory.createJc();
        lvl7.setLvlJc(jc7);
        jc7.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart7 = wmlObjectFactory.createLvlStart();
        lvl7.setStart(lvlstart7);
        lvlstart7.setVal(BigInteger.valueOf(1L));
        Lvl lvl8 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl8);
        lvl8.setIlvl(BigInteger.valueOf(7L));
        PPr ppr8 = wmlObjectFactory.createPPr();
        lvl8.setPPr(ppr8);
        PPrBase.Ind pprbaseind8 = wmlObjectFactory.createPPrBaseInd();
        ppr8.setInd(pprbaseind8);
        pprbaseind8.setLeft(BigInteger.valueOf(5760L));
        pprbaseind8.setHanging(BigInteger.valueOf(360L));
        RPr rpr8 = wmlObjectFactory.createRPr();
        lvl8.setRPr(rpr8);
        RFonts rfonts8 = wmlObjectFactory.createRFonts();
        rpr8.setRFonts(rfonts8);
        rfonts8.setAscii("Courier New");
        rfonts8.setHint(STHint.DEFAULT);
        rfonts8.setHAnsi("Courier New");
        rfonts8.setCs("Courier New");
        NumFmt numfmt8 = wmlObjectFactory.createNumFmt();
        lvl8.setNumFmt(numfmt8);
        numfmt8.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext8 = wmlObjectFactory.createLvlLvlText();
        lvl8.setLvlText(lvllvltext8);
        lvllvltext8.setVal("o");
        Jc jc8 = wmlObjectFactory.createJc();
        lvl8.setLvlJc(jc8);
        jc8.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart8 = wmlObjectFactory.createLvlStart();
        lvl8.setStart(lvlstart8);
        lvlstart8.setVal(BigInteger.valueOf(1L));
        Lvl lvl9 = wmlObjectFactory.createLvl();
        numberingabstractnum.getLvl().add(lvl9);
        lvl9.setIlvl(BigInteger.valueOf(8L));
        PPr ppr9 = wmlObjectFactory.createPPr();
        lvl9.setPPr(ppr9);
        PPrBase.Ind pprbaseind9 = wmlObjectFactory.createPPrBaseInd();
        ppr9.setInd(pprbaseind9);
        pprbaseind9.setLeft(BigInteger.valueOf(6480L));
        pprbaseind9.setHanging(BigInteger.valueOf(360L));
        RPr rpr9 = wmlObjectFactory.createRPr();
        lvl9.setRPr(rpr9);
        RFonts rfonts9 = wmlObjectFactory.createRFonts();
        rpr9.setRFonts(rfonts9);
        rfonts9.setAscii("Wingdings");
        rfonts9.setHint(STHint.DEFAULT);
        rfonts9.setHAnsi("Wingdings");
        NumFmt numfmt9 = wmlObjectFactory.createNumFmt();
        lvl9.setNumFmt(numfmt9);
        numfmt9.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext9 = wmlObjectFactory.createLvlLvlText();
        lvl9.setLvlText(lvllvltext9);
        lvllvltext9.setVal("\uf0a7");
        Jc jc9 = wmlObjectFactory.createJc();
        lvl9.setLvlJc(jc9);
        jc9.setVal(JcEnumeration.LEFT);
        Lvl.Start lvlstart9 = wmlObjectFactory.createLvlStart();
        lvl9.setStart(lvlstart9);
        lvlstart9.setVal(BigInteger.valueOf(1L));
        CTLongHexNumber longhexnumber = wmlObjectFactory.createCTLongHexNumber();
        numberingabstractnum.setNsid(longhexnumber);
        longhexnumber.setVal("2C877BED");
        Numbering.AbstractNum.MultiLevelType numberingabstractnummultileveltype = wmlObjectFactory.createNumberingAbstractNumMultiLevelType();
        numberingabstractnum.setMultiLevelType(numberingabstractnummultileveltype);
        numberingabstractnummultileveltype.setVal("multilevel");
        CTLongHexNumber longhexnumber2 = wmlObjectFactory.createCTLongHexNumber();
        numberingabstractnum.setTmpl(longhexnumber2);
        longhexnumber2.setVal("04905A0A");
        Numbering.AbstractNum.StyleLink numberingabstractnumstylelink = wmlObjectFactory.createNumberingAbstractNumStyleLink();
        numberingabstractnum.setStyleLink(numberingabstractnumstylelink);
        numberingabstractnumstylelink.setVal("MyListStyle");
        return numbering;
    }
}

