/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.frames;

import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;

public class PushPromiseFrame
extends Frame {
    private final int streamId;
    private final int promisedStreamId;
    private final MetaData metaData;

    public PushPromiseFrame(int streamId, MetaData metaData) {
        this(streamId, 0, metaData);
    }

    public PushPromiseFrame(int streamId, int promisedStreamId, MetaData metaData) {
        super(FrameType.PUSH_PROMISE);
        this.streamId = streamId;
        this.promisedStreamId = promisedStreamId;
        this.metaData = metaData;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getPromisedStreamId() {
        return this.promisedStreamId;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public String toString() {
        return String.format("%s#%d/#%d", super.toString(), this.streamId, this.promisedStreamId);
    }
}

