/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.LineIndentInfo;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocation;
import org.eclipse.lemminx.dom.XMLModel;
import org.eclipse.lemminx.dom.parser.Constants;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMDocument
extends DOMNode
implements Document {
    private SchemaLocation schemaLocation;
    private NoNamespaceSchemaLocation noNamespaceSchemaLocation;
    private List<XMLModel> xmlModels;
    private boolean referencedExternalGrammarInitialized;
    private boolean referencedSchemaInitialized;
    private final URIResolverExtensionManager resolverExtensionManager;
    private final TextDocument textDocument;
    private boolean hasNamespaces;
    private Map<String, String> externalSchemaLocation;
    private String schemaInstancePrefix;
    private String schemaPrefix;
    private boolean hasExternalGrammar;
    private CancelChecker cancelChecker;

    public DOMDocument(TextDocument textDocument, URIResolverExtensionManager resolverExtensionManager) {
        super(0, textDocument.getText().length());
        this.textDocument = textDocument;
        this.resolverExtensionManager = resolverExtensionManager;
        this.resetGrammar();
    }

    public void setCancelChecker(CancelChecker cancelChecker) {
        this.cancelChecker = cancelChecker;
    }

    public CancelChecker getCancelChecker() {
        return this.cancelChecker;
    }

    public List<DOMNode> getRoots() {
        return super.getChildren();
    }

    public Position positionAt(int offset) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.positionAt(offset);
    }

    public int offsetAt(Position position) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.offsetAt(position);
    }

    public String lineText(int lineNumber) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.lineText(lineNumber);
    }

    public String lineDelimiter(int lineNumber) throws BadLocationException {
        this.checkCanceled();
        return this.textDocument.lineDelimiter(lineNumber);
    }

    public LineIndentInfo getLineIndentInfo(int lineNumber) throws BadLocationException {
        String lineText = this.lineText(lineNumber);
        String lineDelimiter = this.lineDelimiter(lineNumber);
        String whitespacesIndent = StringUtils.getStartWhitespaces(lineText);
        return new LineIndentInfo(lineDelimiter, whitespacesIndent);
    }

    public Range getElementNameRangeAt(int textOffset) {
        this.checkCanceled();
        return this.textDocument.getWordRangeAt(textOffset, Constants.ELEMENT_NAME_REGEX);
    }

    @Override
    public String getNamespaceURI() {
        DOMElement documentElement = this.getDocumentElement();
        return documentElement != null ? documentElement.getNamespaceURI() : null;
    }

    public String getText() {
        return this.textDocument.getText();
    }

    public TextDocument getTextDocument() {
        return this.textDocument;
    }

    public boolean hasGrammar() {
        return this.hasGrammar(false);
    }

    public boolean hasGrammar(boolean excludeXMLModel) {
        return this.hasDTD() || this.hasSchemaLocation() || this.hasNoNamespaceSchemaLocation() || this.hasExternalGrammar() || !excludeXMLModel && this.hasXMLModel();
    }

    public SchemaLocation getSchemaLocation() {
        this.initializeReferencedSchemaIfNeeded();
        return this.schemaLocation;
    }

    public boolean hasSchemaLocation() {
        return this.getSchemaLocation() != null;
    }

    public NoNamespaceSchemaLocation getNoNamespaceSchemaLocation() {
        this.initializeReferencedSchemaIfNeeded();
        return this.noNamespaceSchemaLocation;
    }

    public boolean hasNoNamespaceSchemaLocation() {
        return this.getNoNamespaceSchemaLocation() != null;
    }

    public boolean hasNamespaces() {
        this.initializeReferencedSchemaIfNeeded();
        return this.hasNamespaces;
    }

    public String getSchemaInstancePrefix() {
        this.initializeReferencedSchemaIfNeeded();
        return this.schemaInstancePrefix;
    }

    public boolean hasSchemaInstancePrefix() {
        this.initializeReferencedSchemaIfNeeded();
        return this.schemaInstancePrefix != null;
    }

    private void initializeReferencedSchemaIfNeeded() {
        if (this.referencedSchemaInitialized) {
            return;
        }
        this.initializeReferencedSchema();
        this.referencedSchemaInitialized = true;
    }

    private synchronized void initializeReferencedSchema() {
        if (this.referencedSchemaInitialized) {
            return;
        }
        this.xmlModels = XMLModel.createXMLModels(this);
        DOMElement documentElement = this.getDocumentElement();
        if (documentElement == null) {
            return;
        }
        this.schemaInstancePrefix = null;
        this.schemaPrefix = null;
        if (documentElement.hasAttributes()) {
            for (DOMAttr attr : documentElement.getAttributeNodes()) {
                String attributeName = attr.getName();
                if (attributeName == null || !attributeName.equals("xmlns") && !attributeName.startsWith("xmlns:")) continue;
                this.hasNamespaces = true;
                String attributeValue = documentElement.getAttribute(attributeName);
                if (attributeValue == null || !attributeValue.startsWith("http://www.w3.org/")) continue;
                if (attributeValue.endsWith("/XMLSchema-instance")) {
                    this.schemaInstancePrefix = attributeName.equals("xmlns") ? "" : DOMDocument.getUnprefixedName(attributeName);
                    continue;
                }
                if (!attributeValue.endsWith("/XMLSchema")) continue;
                this.schemaPrefix = attributeName.equals("xmlns") ? "" : DOMDocument.getUnprefixedName(attributeName);
            }
            if (this.schemaInstancePrefix != null) {
                this.noNamespaceSchemaLocation = DOMDocument.createNoNamespaceSchemaLocation(documentElement, this.schemaInstancePrefix);
                this.schemaLocation = DOMDocument.createSchemaLocation(documentElement, this.schemaInstancePrefix);
            }
        }
    }

    public boolean hasProlog() {
        List<DOMNode> children = this.getChildren();
        return children != null && !children.isEmpty() && children.get(0).isProlog();
    }

    public DOMNode getProlog() {
        if (this.hasProlog()) {
            return this.getChild(0);
        }
        return null;
    }

    public boolean isBeforeProlog(int offset) {
        return this.hasProlog() && offset <= this.getProlog().getStart();
    }

    private static SchemaLocation createSchemaLocation(DOMNode root, String schemaInstancePrefix) {
        DOMAttr attr = root.getAttributeNode(DOMDocument.getPrefixedName(schemaInstancePrefix, "schemaLocation"));
        if (attr == null) {
            return null;
        }
        return new SchemaLocation(attr);
    }

    private static NoNamespaceSchemaLocation createNoNamespaceSchemaLocation(DOMNode root, String schemaInstancePrefix) {
        DOMAttr attr = root.getAttributeNode(DOMDocument.getPrefixedName(schemaInstancePrefix, "noNamespaceSchemaLocation"));
        if (attr == null || attr.getValue() == null) {
            return null;
        }
        return new NoNamespaceSchemaLocation(attr);
    }

    public boolean hasDTD() {
        return this.getDoctype() != null;
    }

    public boolean hasXMLModel() {
        return !this.getXMLModels().isEmpty();
    }

    public List<XMLModel> getXMLModels() {
        this.initializeReferencedSchemaIfNeeded();
        return this.xmlModels;
    }

    private boolean hasExternalGrammar() {
        this.initializeReferencedExternalGrammarIfNeeded();
        return this.hasExternalGrammar;
    }

    public Map<String, String> getExternalSchemaLocation() {
        this.initializeReferencedExternalGrammarIfNeeded();
        return this.externalSchemaLocation;
    }

    private void initializeReferencedExternalGrammarIfNeeded() {
        if (this.referencedExternalGrammarInitialized) {
            return;
        }
        this.hasExternalGrammar = this.intializeExternalGrammar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean intializeExternalGrammar() {
        if (this.referencedExternalGrammarInitialized) {
            return this.hasExternalGrammar;
        }
        try {
            if (this.resolverExtensionManager != null) {
                try {
                    this.externalSchemaLocation = this.resolverExtensionManager.getExternalSchemaLocation(new URI(this.getDocumentURI()));
                    if (this.externalSchemaLocation != null) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                DOMElement documentElement = this.getDocumentElement();
                if (documentElement == null) {
                    boolean bl = false;
                    return bl;
                }
                String namespaceURI = documentElement.getNamespaceURI();
                boolean bl = this.resolverExtensionManager.resolve(this.getDocumentURI(), namespaceURI, null) != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.referencedExternalGrammarInitialized = true;
        }
    }

    private static String getUnprefixedName(String name) {
        int index = name.indexOf(":");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private static String getPrefixedName(String prefix, String localName) {
        return prefix != null && prefix.length() > 0 ? prefix + ":" + localName : localName;
    }

    public DOMElement createElement(int start, int end) {
        return new DOMElement(start, end);
    }

    public DOMCDATASection createCDataSection(int start, int end) {
        return new DOMCDATASection(start, end);
    }

    public DOMProcessingInstruction createProcessingInstruction(int start, int end) {
        return new DOMProcessingInstruction(start, end);
    }

    public DOMComment createComment(int start, int end) {
        return new DOMComment(start, end);
    }

    public DOMText createText(int start, int end) {
        return new DOMText(start, end);
    }

    public DOMDocumentType createDocumentType(int start, int end) {
        return new DOMDocumentType(start, end);
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public DOMElement getDocumentElement() {
        List<DOMNode> roots = this.getRoots();
        if (roots != null) {
            for (DOMNode node : roots) {
                if (!node.isElement()) continue;
                return (DOMElement)node;
            }
        }
        return null;
    }

    @Override
    public DOMDocumentType getDoctype() {
        List<DOMNode> roots = this.getRoots();
        if (roots != null) {
            for (DOMNode node : roots) {
                if (!node.isDoctype()) continue;
                return (DOMDocumentType)node;
            }
        }
        return null;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return this;
    }

    @Override
    public String getDocumentURI() {
        return this.textDocument.getUri();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.textDocument.setUri(documentURI);
    }

    @Override
    public DOMNode adoptNode(Node source) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMAttr createAttribute(String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMAttr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMComment createComment(String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMText createTextNode(String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMElement getElementById(String elementId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getXmlEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getXmlStandalone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getXmlVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMNode importNode(Node importedNode, boolean deep) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void normalizeDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DOMNode renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void resetGrammar() {
        this.referencedExternalGrammarInitialized = false;
        this.referencedSchemaInitialized = false;
    }

    public URIResolverExtensionManager getResolverExtensionManager() {
        return this.resolverExtensionManager;
    }

    public boolean isDTD() {
        String uri = this.getDocumentURI();
        return DOMUtils.isDTD(uri);
    }

    public boolean isWithinInternalDTD(int offset) {
        DOMDocumentType doctype = this.getDoctype();
        if (doctype != null && doctype.internalSubset != null) {
            return offset > doctype.internalSubset.start && offset < doctype.internalSubset.end;
        }
        return false;
    }

    public Range getTrimmedRange(Range range) {
        if (range != null) {
            return this.getTrimmedRange(range.getStart().getCharacter(), range.getEnd().getCharacter());
        }
        return null;
    }

    public Range getTrimmedRange(int start, int end) {
        String text = this.getText();
        char c = text.charAt(start);
        while (Character.isWhitespace(c)) {
            c = text.charAt(++start);
        }
        if (start == end) {
            return null;
        }
        c = text.charAt(--end);
        while (Character.isWhitespace(c)) {
            c = text.charAt(--end);
        }
        return XMLPositionUtility.createRange(start, ++end, this);
    }

    public Collection<DOMNode> findDTDAttrList(String elementName) {
        DOMDocumentType docType = this.getDoctype();
        if (docType == null || elementName == null) {
            return Collections.emptyList();
        }
        return docType.getChildren().stream().filter(DOMNode::isDTDAttListDecl).filter(n -> elementName.equals(((DTDAttlistDecl)n).getElementName())).collect(Collectors.toList());
    }

    public String getSchemaPrefix() {
        this.initializeReferencedSchemaIfNeeded();
        return this.schemaPrefix;
    }

    private void checkCanceled() {
        if (this.cancelChecker != null) {
            this.cancelChecker.checkCanceled();
        }
    }
}

