/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.ContentModelCodeActionParticipant;
import org.eclipse.lemminx.extensions.contentmodel.participants.ContentModelCompletionParticipant;
import org.eclipse.lemminx.extensions.contentmodel.participants.ContentModelDocumentLinkParticipant;
import org.eclipse.lemminx.extensions.contentmodel.participants.ContentModelHoverParticipant;
import org.eclipse.lemminx.extensions.contentmodel.participants.ContentModelTypeDefinitionParticipant;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.ContentModelDiagnosticsParticipant;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.services.extensions.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.ITypeDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.InitializeParams;

public class ContentModelPlugin
implements IXMLExtension {
    private final ICompletionParticipant completionParticipant = new ContentModelCompletionParticipant();
    private final IHoverParticipant hoverParticipant = new ContentModelHoverParticipant();
    private final IDiagnosticsParticipant diagnosticsParticipant = new ContentModelDiagnosticsParticipant(this);
    private final ICodeActionParticipant codeActionParticipant = new ContentModelCodeActionParticipant();
    private final IDocumentLinkParticipant documentLinkParticipant = new ContentModelDocumentLinkParticipant();
    private final ITypeDefinitionParticipant typeDefinitionParticipant = new ContentModelTypeDefinitionParticipant();
    ContentModelManager contentModelManager;
    private ContentModelSettings cmSettings;

    @Override
    public void doSave(ISaveContext context) {
        if (context.getType() == ISaveContext.SaveContextType.DOCUMENT) {
            String documentURI = context.getUri();
            DOMDocument document = context.getDocument(documentURI);
            if (document != null && DOMUtils.isCatalog(document)) {
                this.contentModelManager.refreshCatalogs();
            }
            context.collectDocumentToValidate(d -> {
                DOMDocument xml = context.getDocument(d.getDocumentURI());
                xml.resetGrammar();
                return !documentURI.equals(d.getDocumentURI());
            });
        } else {
            this.updateSettings(context);
        }
    }

    private void updateSettings(ISaveContext saveContext) {
        Object initializationOptionsSettings = saveContext.getSettings();
        this.cmSettings = ContentModelSettings.getContentModelXMLSettings(initializationOptionsSettings);
        if (this.cmSettings != null) {
            this.updateSettings(this.cmSettings, saveContext);
        }
    }

    private void updateSettings(ContentModelSettings settings, ISaveContext context) {
        Boolean useCache;
        boolean fileAssociationsChanged;
        boolean catalogPathsChanged;
        if (settings.getCatalogs() != null && (catalogPathsChanged = this.contentModelManager.setCatalogs(settings.getCatalogs()))) {
            context.collectDocumentToValidate(d -> {
                DOMDocument xml = context.getDocument(d.getDocumentURI());
                if (xml == null) {
                    return false;
                }
                xml.resetGrammar();
                return true;
            });
        }
        if (settings.getFileAssociations() != null && (fileAssociationsChanged = this.contentModelManager.setFileAssociations(settings.getFileAssociations()))) {
            context.collectDocumentToValidate(d -> {
                DOMDocument xml = context.getDocument(d.getDocumentURI());
                xml.resetGrammar();
                return true;
            });
        }
        if ((useCache = settings.isUseCache()) != null) {
            this.contentModelManager.setUseCache(useCache);
        }
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        URIResolverExtensionManager resolverManager = (URIResolverExtensionManager)registry.getComponent(URIResolverExtensionManager.class);
        this.contentModelManager = new ContentModelManager(resolverManager);
        registry.registerComponent(this.contentModelManager);
        if (params != null) {
            this.contentModelManager.setRootURI(params.getRootUri());
        }
        registry.registerCompletionParticipant(this.completionParticipant);
        registry.registerHoverParticipant(this.hoverParticipant);
        registry.registerDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.registerCodeActionParticipant(this.codeActionParticipant);
        registry.registerDocumentLinkParticipant(this.documentLinkParticipant);
        registry.registerTypeDefinitionParticipant(this.typeDefinitionParticipant);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.unregisterCompletionParticipant(this.completionParticipant);
        registry.unregisterHoverParticipant(this.hoverParticipant);
        registry.unregisterDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.unregisterCodeActionParticipant(this.codeActionParticipant);
        registry.unregisterDocumentLinkParticipant(this.documentLinkParticipant);
        registry.unregisterTypeDefinitionParticipant(this.typeDefinitionParticipant);
    }

    public ContentModelSettings getContentModelSettings() {
        return this.cmSettings;
    }

    public ContentModelManager getContentModelManager() {
        return this.contentModelManager;
    }
}

