/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import java.io.File;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.references.XMLReferencesSettingsForTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.CodeLens;
import org.junit.jupiter.api.Test;

public class XMLReferencesCodeLensExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void tei() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n    <body xml:id=\"body-id\">\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"#body-id\"></anchor>\r\n    </body>\r\n  </text>\r\n</TEI>";
        XMLReferencesCodeLensExtensionsTest.testCodeLensFor(xml, "file:///test/tei.xml", XMLAssert.cl(XMLAssert.r(16, 10, 16, 26), "1 reference", "xml.show.references"));
    }

    @Test
    public void teiTargetMulti() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A #B\" />\r\n\t\t<link target=\"#B\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCodeLensExtensionsTest.testCodeLensFor(xml, "file:///test/tei.xml", XMLAssert.cl(XMLAssert.r(5, 6, 5, 16), "1 reference", "xml.show.references"), XMLAssert.cl(XMLAssert.r(6, 6, 6, 16), "2 references", "xml.show.references"));
    }

    @Test
    public void web() throws BadLocationException {
        String xml = "<web-app xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  version=\"3.1\">\r\n  <servlet>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <servlet-class>mysite.server.ComingSoonServlet</servlet-class>\r\n  </servlet>\r\n  <servlet-mapping>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n</web-app>\r\n";
        XMLReferencesCodeLensExtensionsTest.testCodeLensFor(xml, "file:///test/web.xml", XMLAssert.cl(XMLAssert.r(4, 18, 4, 28), "1 reference", "xml.show.references"));
    }

    @Test
    public void attrToText() throws BadLocationException {
        String xml = "<aaa ref=\"child1 child2 child3\">\r\n  <bbb>child1</bbb>\r\n  <bbb>child2</bbb>\r\n  <bbb>child3</bbb>\r\n</aaa>";
        XMLReferencesCodeLensExtensionsTest.testCodeLensFor(xml, "file:///test/attr-to-text.xml", XMLAssert.cl(XMLAssert.r(1, 7, 1, 13), "1 reference", "xml.show.references"), XMLAssert.cl(XMLAssert.r(2, 7, 2, 13), "1 reference", "xml.show.references"), XMLAssert.cl(XMLAssert.r(3, 7, 3, 13), "1 reference", "xml.show.references"));
    }

    @Test
    public void docbookWithoutInclude() throws BadLocationException {
        String xml = "<docbook>\r\n\t<xref linkend=\"s1\" />\r\n\t<section id=\"s1\" />\r\n\t<xref linkend=\"ch1\" />\r\n</docbook>";
        XMLReferencesCodeLensExtensionsTest.testCodeLensFor(xml, new File("src/test/resources/xml/docbook.xml").toURI().toString(), XMLAssert.cl(XMLAssert.r(2, 10, 2, 17), "1 reference", "xml.show.references"));
    }

    @Test
    public void docbookWithInclude() throws BadLocationException {
        String xml = "<docbook>\r\n\t<xref linkend=\"s1\" />\r\n\t<section id=\"s1\" />\r\n\t<xref linkend=\"ch1\" />\r\n\t<xi:include href=\"sub-book.xml\" />\r\n</docbook>";
        XMLReferencesCodeLensExtensionsTest.testCodeLensFor(xml, new File("src/test/resources/xml/docbook.xml").toURI().toString(), XMLAssert.cl(XMLAssert.r(2, 10, 2, 17), "3 references", "xml.show.references"));
    }

    private static void testCodeLensFor(String value, String fileURI, CodeLens ... expected) {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        xmlLanguageService.getExtensions();
        Consumer<XMLLanguageService> customConfiguration = ls -> ls.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(XMLReferencesSettingsForTest.createXMLReferencesSettings()));
        XMLAssert.testCodeLensFor(value, fileURI, xmlLanguageService, Arrays.asList("references"), customConfiguration, expected);
    }
}

