/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.dom.parser.Constants;

public class MultiLineStream {
    private static final Predicate<Integer> WHITESPACE_PREDICATE = ch -> ch == Constants._WSP || ch == Constants._TAB || ch == Constants._NWL || ch == Constants._LFD || ch == Constants._CAR;
    private final String source;
    private final int len;
    private int position;
    private final Map<Pattern, Matcher> regexpCache;

    public MultiLineStream(String source, int position) {
        this.source = source;
        this.len = source.length();
        this.position = position;
        this.regexpCache = new HashMap<Pattern, Matcher>();
    }

    public boolean eos() {
        return this.len <= this.position;
    }

    public String getSource() {
        return this.source;
    }

    public int pos() {
        return this.position;
    }

    public void goBackTo(int pos) {
        this.position = pos;
    }

    public void goBack(int n) {
        this.position -= n;
    }

    public void advance(int n) {
        this.position += n;
    }

    public void goToEnd() {
        this.position = this.len;
    }

    public int peekChar() {
        return this.peekChar(0);
    }

    public int peekChar(int n) {
        int pos = this.position + n;
        if (pos >= this.len) {
            return -1;
        }
        return this.source.codePointAt(pos);
    }

    public int peekCharAtOffset(int offset) {
        if (offset >= this.len || offset < 0) {
            return -1;
        }
        return this.source.codePointAt(offset);
    }

    public boolean advanceIfChar(int ch) {
        if (ch == this.peekChar()) {
            ++this.position;
            return true;
        }
        return false;
    }

    public boolean advanceIfChars(int[] ch) {
        int i;
        if (this.position + ch.length > this.len) {
            return false;
        }
        for (i = 0; i < ch.length; ++i) {
            if (this.peekChar(i) == ch[i]) continue;
            return false;
        }
        this.advance(i);
        return true;
    }

    public int advanceIfAnyOfChars(int[] ch) {
        if (this.position + 1 > this.len) {
            return -1;
        }
        for (int i = 0; i < ch.length; ++i) {
            if (!this.advanceIfChar(ch[i])) continue;
            return ch[i];
        }
        return -1;
    }

    public String advanceIfRegExp(Pattern regex) {
        Matcher match = this.getCachedMatcher(regex);
        match.region(this.position, this.len);
        if (match.find()) {
            this.position = match.end();
            return match.group(0);
        }
        return "";
    }

    public String advanceIfRegExpGroup1(Pattern regex) {
        Matcher match = this.getCachedMatcher(regex);
        match.region(this.position, this.len);
        if (match.find()) {
            this.position = match.end(1);
            return match.group(1);
        }
        return "";
    }

    public boolean advanceUntilChar(int ch) {
        while (this.position < this.len) {
            if (this.peekChar() == ch) {
                return true;
            }
            this.advance(1);
        }
        return false;
    }

    public boolean advanceUntilAnyOfChars(int[] ch) {
        while (this.position < this.len) {
            for (int i = 0; i < ch.length; ++i) {
                if (this.peekChar() != ch[i]) continue;
                return true;
            }
            this.advance(1);
        }
        return false;
    }

    public boolean advanceUntilCharOrNewTag(int ch) {
        while (this.position < this.len) {
            if (this.peekChar() == ch || this.peekChar() == Constants._LAN) {
                return true;
            }
            this.advance(1);
        }
        return false;
    }

    public boolean advanceUntilCharUsingStack(int closingBracket) {
        int openingBracket;
        if (closingBracket == Constants._RAN) {
            openingBracket = Constants._LAN;
        } else if (closingBracket == Constants._CSB) {
            openingBracket = Constants._OSB;
        } else {
            return false;
        }
        int stack = 0;
        while (this.position < this.len) {
            if (this.peekChar() == openingBracket) {
                ++stack;
            } else if (this.peekChar() == closingBracket) {
                if (stack == 0) {
                    return true;
                }
                --stack;
            }
            this.advance(1);
        }
        return false;
    }

    public boolean advanceUntilChars(int[] ch) {
        while (this.position + ch.length <= this.len) {
            int i;
            for (i = 0; i < ch.length && this.peekChar(i) == ch[i]; ++i) {
            }
            if (i == ch.length) {
                return true;
            }
            this.advance(1);
        }
        this.goToEnd();
        return false;
    }

    public boolean advanceUntilCharsOrNewTag(int[] ch) {
        while (this.position + ch.length <= this.len) {
            int i;
            if (this.peekChar(0) == Constants._LAN) {
                return true;
            }
            for (i = 0; i < ch.length && this.peekChar(i) == ch[i]; ++i) {
            }
            if (i == ch.length) {
                return true;
            }
            this.advance(1);
        }
        this.goToEnd();
        return false;
    }

    public boolean skipWhitespace() {
        int n = this.advanceWhileChar(WHITESPACE_PREDICATE);
        return n > 0;
    }

    public int advanceWhileChar(Predicate<Integer> condition) {
        int posNow = this.position;
        while (this.position < this.len && condition.test(this.peekChar())) {
            ++this.position;
        }
        return this.position - posNow;
    }

    private Matcher getCachedMatcher(Pattern regex) {
        Matcher matcher = this.regexpCache.get(regex);
        if (matcher == null) {
            matcher = regex.matcher(this.source);
            this.regexpCache.put(regex, matcher);
        } else {
            matcher.reset();
        }
        return matcher;
    }

    public int getLastNonWhitespaceOffset() {
        int posNow;
        for (posNow = this.position; posNow > 0 && WHITESPACE_PREDICATE.test(this.peekCharAtOffset(posNow - 1)); --posNow) {
        }
        return posNow;
    }
}

