/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.validator;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLModelUtils;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missingelement.required_element_missingCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.missingelement.required_elements_missing_expectedCodeAction;
import org.eclipse.lemminx.extensions.relaxng.utils.RelaxNGUtils;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Range;

public enum RelaxNGErrorCode implements IXMLErrorCode
{
    unknown_element,
    unexpected_element_required_element_missing,
    unexpected_element_required_elements_missing,
    element_not_allowed_yet,
    out_of_context_element,
    no_attributes_allowed,
    invalid_attribute_name,
    invalid_attribute_value,
    required_attributes_missing_expected,
    required_attribute_missing,
    required_attributes_missing,
    incomplete_element_required_elements_missing_expected,
    incomplete_element_required_element_missing,
    incomplete_element_required_elements_missing,
    text_not_allowed,
    document_incomplete,
    invalid_element_value,
    blank_not_allowed,
    schema_allows_nothing,
    RelaxNGNotFound,
    missing_start_element,
    reference_to_undefined,
    duplicate_define,
    duplicate_start,
    unrecognized_datatype,
    expected_pattern,
    illegal_attribute_ignored,
    illegal_name_attribute,
    invalid_ncname,
    missing_children,
    missing_name_attribute,
    missing_name_class,
    missing_type_attribute,
    to_implement;

    private final String code;
    private static final Map<String, RelaxNGErrorCode> codes;

    private RelaxNGErrorCode() {
        this(null);
    }

    private RelaxNGErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public static RelaxNGErrorCode get(String name) {
        return codes.get(name);
    }

    public static Range toLSPRange(XMLLocator location, RelaxNGErrorCode rngCode, Object[] arguments, DOMDocument document) {
        int offset = location.getCharacterOffset() - 1;
        switch (rngCode) {
            case unknown_element: 
            case out_of_context_element: 
            case element_not_allowed_yet: 
            case incomplete_element_required_elements_missing_expected: 
            case unexpected_element_required_element_missing: 
            case incomplete_element_required_element_missing: 
            case required_attributes_missing_expected: 
            case required_attributes_missing: 
            case required_attribute_missing: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case no_attributes_allowed: 
            case invalid_attribute_name: {
                String attrName = (String)arguments[0];
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case invalid_attribute_value: {
                String attrName = (String)arguments[0];
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case RelaxNGNotFound: {
                String hrefLocation = (String)arguments[1];
                DOMRange locationRange = XMLModelUtils.getHrefNode(document, hrefLocation);
                if (locationRange != null) {
                    return XMLPositionUtility.createRange(locationRange);
                }
            }
            case missing_start_element: {
                DOMNode node = document.findNodeAt(offset);
                if (node != null && node.isElement() && "grammar".equals(((DOMElement)node).getLocalName())) {
                    return XMLPositionUtility.selectStartTagName((DOMElement)node);
                }
            }
            case reference_to_undefined: {
                String refName = (String)arguments[0];
                DOMAttr refAttrName = RelaxNGErrorCode.findRefByName(document, refName);
                if (refAttrName != null) {
                    return XMLPositionUtility.selectAttributeValue(refAttrName);
                }
            }
            case duplicate_define: {
                String attrValue = (String)arguments[0];
                return XMLPositionUtility.selectAttributeValueFromGivenValue(attrValue, offset, document);
            }
            case duplicate_start: 
            case unrecognized_datatype: {
                DOMElement data;
                DOMAttr attr;
                DOMNode node = document.findNodeAt(offset);
                if (node != null && node.isElement() && (attr = (data = (DOMElement)node).getAttributeNode("type")) != null) {
                    return XMLPositionUtility.selectAttributeValue(attr);
                }
            }
            case expected_pattern: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case illegal_name_attribute: {
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt("name", offset, document);
            }
            case illegal_attribute_ignored: {
                String attrName = (String)arguments[0];
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case invalid_ncname: {
                DOMNode node = document.findNodeAt(offset);
                if (node != null && node.isElement() && "name".equals(((DOMElement)node).getLocalName())) {
                    DOMElement name = (DOMElement)node;
                    boolean hasText = DOMUtils.containsTextOnly(name);
                    return hasText ? XMLPositionUtility.selectText((DOMText)name.getFirstChild()) : XMLPositionUtility.selectStartTagName((DOMElement)node);
                }
                return XMLPositionUtility.selectAttributeValueAt("name", offset, false, document);
            }
            case missing_children: 
            case missing_name_attribute: 
            case missing_name_class: 
            case missing_type_attribute: {
                DOMNode node = document.findNodeAt(offset);
                if (node == null || !node.isElement()) break;
                return XMLPositionUtility.selectStartTagName((DOMElement)node);
            }
        }
        return null;
    }

    public static void registerCodeActionParticipants(Map<String, ICodeActionParticipant> codeActions, SharedSettings sharedSettings) {
        codeActions.put(incomplete_element_required_element_missing.getCode(), new required_element_missingCodeAction());
        codeActions.put(incomplete_element_required_elements_missing_expected.getCode(), new required_elements_missing_expectedCodeAction());
    }

    private static DOMAttr findRefByName(DOMNode parent, String refName) {
        for (DOMNode child : parent.getChildren()) {
            DOMElement ref;
            DOMAttr attr;
            if (child.isElement() && RelaxNGUtils.isRef((DOMElement)child) && (attr = (ref = (DOMElement)child).getAttributeNode("name")) != null && refName.equals(attr.getValue())) {
                return attr;
            }
            DOMAttr attr2 = RelaxNGErrorCode.findRefByName(child, refName);
            if (attr2 == null) continue;
            return attr2;
        }
        return null;
    }

    static {
        codes = new HashMap<String, RelaxNGErrorCode>();
        for (RelaxNGErrorCode errorCode : RelaxNGErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

