/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.mojos;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.CachingWriter;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SisuIndex;
import org.eclipse.sisu.space.URLClassSpace;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="index", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class IndexMojo
extends AbstractMojo {
    static final String INDEX_FOLDER = "META-INF/sisu/";
    @Parameter(property="outputDirectory", defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(property="includeDependencies", defaultValue="true")
    protected boolean includeDependencies;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeClassifiers", defaultValue="")
    protected String excludeClassifiers;
    @Parameter(property="includeClassifiers", defaultValue="")
    protected String includeClassifiers;
    @Parameter(property="excludeTypes", defaultValue="")
    protected String excludeTypes;
    @Parameter(property="includeTypes", defaultValue="")
    protected String includeTypes;
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;
    @Parameter(property="includeScope", defaultValue="")
    protected String includeScope;
    @Parameter(property="excludeTransitive", defaultValue="false")
    protected boolean excludeTransitive;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Component
    protected BuildContext buildContext;

    public IndexMojo() {
    }

    public IndexMojo(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        MavenProject mavenProject = this.project;
        synchronized (mavenProject) {
            new SisuIndex(this.outputDirectory){

                protected Writer getWriter(String path) throws IOException {
                    Path p = IndexMojo.this.outputDirectory.toPath().resolve(path);
                    Path d = p.getParent();
                    if (!Files.isDirectory(d, new LinkOption[0])) {
                        Files.createDirectories(d, new FileAttribute[0]);
                    }
                    return new CachingWriter(p, StandardCharsets.UTF_8);
                }

                protected void info(String message) {
                    IndexMojo.this.getLog().info((CharSequence)message);
                }

                protected void warn(String message) {
                    IndexMojo.this.getLog().warn((CharSequence)message);
                }
            }.index((ClassSpace)new URLClassSpace(this.getProjectClassLoader(), this.getIndexPath()));
            this.buildContext.refresh(new File(this.outputDirectory, INDEX_FOLDER));
        }
    }

    private ClassLoader getProjectClassLoader() {
        ArrayList<URL> classPath = new ArrayList<URL>();
        this.appendDirectoryToClassPath(classPath, this.outputDirectory);
        for (Object artifact : this.project.getArtifacts()) {
            this.appendFileToClassPath(classPath, ((Artifact)artifact).getFile());
        }
        if (this.getLog().isDebugEnabled()) {
            this.dumpEntries("classPath", classPath);
        }
        return URLClassLoader.newInstance(classPath.toArray(new URL[classPath.size()]));
    }

    private URL[] getIndexPath() {
        ArrayList<URL> indexPath = new ArrayList<URL>();
        this.appendDirectoryToClassPath(indexPath, this.outputDirectory);
        if (this.includeDependencies && !this.buildContext.isIncremental()) {
            FilterArtifacts filter = new FilterArtifacts();
            filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.project.getDependencyArtifacts(), this.excludeTransitive));
            filter.addFilter((ArtifactsFilter)new ScopeFilter(IndexMojo.cleanList(this.includeScope), IndexMojo.cleanList(this.excludeScope)));
            filter.addFilter((ArtifactsFilter)new TypeFilter(IndexMojo.cleanList(this.includeTypes), IndexMojo.cleanList(this.excludeTypes)));
            filter.addFilter((ArtifactsFilter)new ClassifierFilter(IndexMojo.cleanList(this.includeClassifiers), IndexMojo.cleanList(this.excludeClassifiers)));
            filter.addFilter((ArtifactsFilter)new GroupIdFilter(IndexMojo.cleanList(this.includeGroupIds), IndexMojo.cleanList(this.excludeGroupIds)));
            filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(IndexMojo.cleanList(this.includeArtifactIds), IndexMojo.cleanList(this.excludeArtifactIds)));
            try {
                for (Object artifact : filter.filter(this.project.getArtifacts())) {
                    this.appendFileToClassPath(indexPath, ((Artifact)artifact).getFile());
                }
            }
            catch (ArtifactFilterException e) {
                this.getLog().warn((CharSequence)e.getLocalizedMessage());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.dumpEntries("indexPath", indexPath);
        }
        return indexPath.toArray(new URL[indexPath.size()]);
    }

    private void dumpEntries(String name, List<URL> urls) {
        this.getLog().debug((CharSequence)(name + " entries: (" + urls.size() + ")"));
        for (int i = 1; i <= urls.size(); ++i) {
            this.getLog().debug((CharSequence)(i + ". " + urls.get(i - 1)));
        }
    }

    private void appendDirectoryToClassPath(List<URL> urls, File directory) {
        if (directory.isDirectory()) {
            Scanner scanner = this.buildContext.newScanner(directory);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            if (includedFiles != null && includedFiles.length > 0) {
                this.getLog().debug((CharSequence)("Found at least one class file in " + directory));
                this.appendFileToClassPath(urls, directory);
            } else {
                this.getLog().debug((CharSequence)("No class files found in " + directory));
            }
        } else {
            this.getLog().debug((CharSequence)("Path " + directory + " does not exist or is no directory"));
        }
    }

    private void appendFileToClassPath(List<URL> urls, File file) {
        if (null != file) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)e.getLocalizedMessage());
            }
        }
    }

    private static String cleanList(String list) {
        return StringUtils.isEmpty((String)list) ? "" : StringUtils.join((Object[])StringUtils.split((String)list), (String)",");
    }
}

