/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.maven.surefire.api.util.SureFireFileManager;
import org.apache.maven.surefire.api.util.internal.StringUtils;

final class Utf8RecodingDeferredFileOutputStream {
    private static final byte[] NL_BYTES = StringUtils.NL.getBytes(StandardCharsets.UTF_8);
    public static final int CACHE_SIZE = 65536;
    private final String channel;
    private Path file;
    private RandomAccessFile storage;
    private boolean closed;
    private SoftReference<byte[]> largeCache;
    private ByteBuffer cache;
    private boolean isDirty;

    Utf8RecodingDeferredFileOutputStream(String channel) {
        this.channel = Objects.requireNonNull(channel);
    }

    public synchronized void write(String output, boolean newLine) throws IOException {
        int newLineLength;
        if (this.closed) {
            return;
        }
        if (this.storage == null) {
            this.file = SureFireFileManager.createTempFile(this.channel, "deferred").toPath();
            this.storage = new RandomAccessFile(this.file.toFile(), "rw");
        }
        if (output == null) {
            output = "null";
        }
        if (this.cache == null) {
            this.cache = ByteBuffer.allocate(65536);
        }
        this.isDirty = true;
        byte[] decodedString = output.getBytes(StandardCharsets.UTF_8);
        int n = newLineLength = newLine ? NL_BYTES.length : 0;
        if (this.cache.remaining() >= decodedString.length + newLineLength) {
            this.cache.put(decodedString);
            if (newLine) {
                this.cache.put(NL_BYTES);
            }
        } else {
            ((Buffer)this.cache).flip();
            int minLength = this.cache.remaining() + decodedString.length + NL_BYTES.length;
            byte[] buffer = this.getLargeCache(minLength);
            int bufferLength = 0;
            System.arraycopy(this.cache.array(), this.cache.arrayOffset() + this.cache.position(), buffer, bufferLength, this.cache.remaining());
            ((Buffer)this.cache).clear();
            System.arraycopy(decodedString, 0, buffer, bufferLength += this.cache.remaining(), decodedString.length);
            bufferLength += decodedString.length;
            if (newLine) {
                System.arraycopy(NL_BYTES, 0, buffer, bufferLength, NL_BYTES.length);
                bufferLength += NL_BYTES.length;
            }
            this.storage.write(buffer, 0, bufferLength);
        }
    }

    public synchronized long getByteCount() {
        try {
            this.sync();
            if (this.storage != null && !this.closed) {
                this.storage.getFD().sync();
            }
            return this.file == null ? 0L : Files.size(this.file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeTo(OutputStream out) throws IOException {
        if (this.file != null && Files.notExists(this.file, new LinkOption[0])) {
            this.storage = null;
        }
        if (this.storage == null && this.file != null || this.storage != null && !this.storage.getChannel().isOpen()) {
            this.storage = new RandomAccessFile(this.file.toFile(), "rw");
        }
        if (this.storage != null) {
            this.sync();
            long currentFilePosition = this.storage.getFilePointer();
            this.storage.seek(0L);
            try {
                int readCount;
                byte[] buffer = new byte[65536];
                while ((readCount = this.storage.read(buffer)) != -1) {
                    out.write(buffer, 0, readCount);
                }
            }
            finally {
                this.storage.seek(currentFilePosition);
            }
        }
    }

    public synchronized void commit() {
        if (this.storage == null) {
            return;
        }
        try {
            this.sync();
            this.storage.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.storage = null;
            this.cache = null;
            this.largeCache = null;
        }
    }

    public synchronized void free() {
        if (!this.closed) {
            this.closed = true;
            if (this.file != null) {
                try {
                    this.commit();
                }
                catch (UncheckedIOException uncheckedIOException) {
                }
                finally {
                    this.file.toFile().deleteOnExit();
                }
                this.storage = null;
                this.cache = null;
                this.largeCache = null;
            }
        }
    }

    private void sync() throws IOException {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        if (this.storage != null && this.cache != null) {
            ((Buffer)this.cache).flip();
            byte[] array = this.cache.array();
            int offset = this.cache.arrayOffset() + this.cache.position();
            int length = this.cache.remaining();
            ((Buffer)this.cache).clear();
            this.storage.write(array, offset, length);
        }
    }

    private byte[] getLargeCache(int minLength) {
        byte[] buffer;
        if (this.largeCache == null || (buffer = this.largeCache.get()) == null || buffer.length < minLength) {
            buffer = new byte[minLength];
            this.largeCache = new SoftReference<byte[]>(buffer);
        }
        return buffer;
    }
}

