/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.BaseProviderFactory;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.booter.DumpErrorSingleton;
import org.apache.maven.surefire.api.booter.ForkingReporterFactory;
import org.apache.maven.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.provider.CommandListener;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.provider.SurefireProvider;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.api.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.api.util.internal.StringUtils;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.booter.ForkedNodeArg;
import org.apache.maven.surefire.booter.LazyTestsToRun;
import org.apache.maven.surefire.booter.PpidChecker;
import org.apache.maven.surefire.booter.ProcessCheckerType;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.booter.spi.LegacyMasterProcessChannelProcessorFactory;
import org.apache.maven.surefire.booter.spi.SurefireMasterProcessChannelProcessorFactory;
import org.apache.maven.surefire.shared.utils.cli.ShutdownHookUtils;
import org.apache.maven.surefire.spi.MasterProcessChannelProcessorFactory;

public final class ForkedBooter {
    private static final long DEFAULT_SYSTEM_EXIT_TIMEOUT_IN_SECONDS = 30L;
    private static final long PING_TIMEOUT_IN_SECONDS = 30L;
    private static final String LAST_DITCH_SHUTDOWN_THREAD = "surefire-forkedjvm-last-ditch-daemon-shutdown-thread-";
    private static final String PING_THREAD = "surefire-forkedjvm-ping-";
    private static final String PROCESS_CHECKER_THREAD = "surefire-process-checker";
    private static final String PROCESS_PIPES_ERROR = "The channel (std/out or TCP/IP) failed to send a stream from this subprocess.";
    private final Semaphore exitBarrier = new Semaphore(0);
    private volatile MasterProcessChannelEncoder eventChannel;
    private volatile ConsoleLogger logger;
    private volatile MasterProcessChannelProcessorFactory channelProcessorFactory;
    private volatile CommandReader commandReader;
    private volatile long systemExitTimeoutInSeconds = 30L;
    private volatile PingScheduler pingScheduler;
    private ScheduledThreadPoolExecutor jvmTerminator;
    private ProviderConfiguration providerConfiguration;
    private ForkingReporterFactory forkingReporterFactory;
    private StartupConfiguration startupConfiguration;
    private Object testSet;

    private void setupBooter(String tmpDir, String dumpFileName, String surefirePropsFileName, String effectiveSystemPropertiesFileName) throws IOException {
        BooterDeserializer booterDeserializer = new BooterDeserializer(ForkedBooter.createSurefirePropertiesIfFileExists(tmpDir, surefirePropsFileName));
        SystemPropertyManager.setSystemProperties(new File(tmpDir, effectiveSystemPropertiesFileName));
        this.providerConfiguration = booterDeserializer.deserialize();
        DumpErrorSingleton.getSingleton().init(this.providerConfiguration.getReporterConfiguration().getReportsDirectory(), dumpFileName);
        int forkNumber = booterDeserializer.getForkNumber();
        if (ForkedBooter.isDebugging()) {
            DumpErrorSingleton.getSingleton().dumpText("Found Maven process ID " + booterDeserializer.getPluginPid() + " for the fork " + forkNumber + ".");
        }
        this.startupConfiguration = booterDeserializer.getStartupConfiguration();
        String channelConfig = booterDeserializer.getConnectionString();
        this.channelProcessorFactory = ForkedBooter.lookupDecoderFactory(channelConfig);
        this.channelProcessorFactory.connect(channelConfig);
        boolean isDebugging = ForkedBooter.isDebugging();
        boolean debug = isDebugging || this.providerConfiguration.getMainCliOptions().contains((Object)CommandLineOption.LOGGING_LEVEL_DEBUG);
        ForkedNodeArg args = new ForkedNodeArg(forkNumber, debug);
        this.eventChannel = this.channelProcessorFactory.createEncoder((ForkNodeArguments)args);
        MasterProcessChannelDecoder decoder = this.channelProcessorFactory.createDecoder((ForkNodeArguments)args);
        this.flushEventChannelOnExit();
        this.forkingReporterFactory = this.createForkingReporterFactory();
        this.logger = this.forkingReporterFactory.createTestReportListener();
        this.commandReader = new CommandReader(decoder, this.providerConfiguration.getShutdown(), this.logger);
        this.pingScheduler = isDebugging ? null : this.listenToShutdownCommands(booterDeserializer.getPluginPid());
        this.systemExitTimeoutInSeconds = this.providerConfiguration.systemExitTimeout(30L);
        AbstractPathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        if (classpathConfiguration.isClassPathConfig()) {
            if (this.startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
                classpathConfiguration.toRealPath(ClasspathConfiguration.class).trickClassPathWhenManifestOnlyClasspath();
            }
            this.startupConfiguration.writeSurefireTestClasspathProperty();
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader.setDefaultAssertionStatus(classpathConfiguration.isEnableAssertions());
        boolean readTestsFromCommandReader = this.providerConfiguration.isReadTestsFromInStream();
        this.testSet = this.createTestSet(this.providerConfiguration.getTestForFork(), readTestsFromCommandReader, classLoader);
    }

    private void execute() {
        try {
            this.runSuitesInProcess();
        }
        catch (Throwable t) {
            Throwable e = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t;
            DumpErrorSingleton.getSingleton().dumpException(e);
            this.logger.error(e.getLocalizedMessage(), e);
        }
        finally {
            Thread.interrupted();
            if (this.eventChannel.checkError()) {
                DumpErrorSingleton.getSingleton().dumpText(PROCESS_PIPES_ERROR);
                this.logger.error(PROCESS_PIPES_ERROR);
            }
            this.acknowledgedExit();
        }
    }

    private Object createTestSet(TypeEncodedValue forkedTestSet, boolean readTestsFromCommandReader, ClassLoader cl) {
        if (forkedTestSet != null) {
            return forkedTestSet.getDecodedValue(cl);
        }
        if (readTestsFromCommandReader) {
            return new LazyTestsToRun(this.eventChannel, this.commandReader);
        }
        return null;
    }

    private void cancelPingScheduler() {
        if (this.pingScheduler != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ForkedBooter.this.pingScheduler.shutdown();
                        return null;
                    }
                });
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    private void closeForkChannel() {
        if (this.channelProcessorFactory != null) {
            try {
                this.channelProcessorFactory.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private PingScheduler listenToShutdownCommands(String ppid) {
        PpidChecker ppidChecker = ppid == null ? null : new PpidChecker(ppid);
        this.commandReader.addShutdownListener(this.createExitHandler(ppidChecker));
        AtomicBoolean pingDone = new AtomicBoolean(true);
        this.commandReader.addNoopListener(this.createPingHandler(pingDone));
        PingScheduler pingMechanisms = new PingScheduler(ForkedBooter.createScheduler("surefire-forkedjvm-ping-30s"), ForkedBooter.createScheduler(PROCESS_CHECKER_THREAD), ppidChecker);
        ProcessCheckerType checkerType = this.startupConfiguration.getProcessChecker();
        if ((checkerType == ProcessCheckerType.ALL || checkerType == ProcessCheckerType.NATIVE) && pingMechanisms.processChecker != null) {
            this.logger.debug(pingMechanisms.processChecker.toString());
            if (pingMechanisms.processChecker.canUse()) {
                Runnable checkerJob = this.processCheckerJob(pingMechanisms);
                pingMechanisms.processCheckerScheduler.scheduleWithFixedDelay(checkerJob, 0L, 1L, TimeUnit.SECONDS);
            } else if (!pingMechanisms.processChecker.isStopped()) {
                this.logger.warning("Cannot use process checker with configuration " + (Object)((Object)checkerType) + ". Platform not supported.");
            }
        }
        if (checkerType == ProcessCheckerType.ALL || checkerType == ProcessCheckerType.PING) {
            Runnable pingJob = this.createPingJob(pingDone, pingMechanisms.processChecker);
            pingMechanisms.pingScheduler.scheduleWithFixedDelay(pingJob, 0L, 30L, TimeUnit.SECONDS);
        }
        return pingMechanisms;
    }

    private Runnable processCheckerJob(final PingScheduler pingMechanism) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (pingMechanism.processChecker.canUse() && !pingMechanism.processChecker.isProcessAlive() && !pingMechanism.pingScheduler.isShutdown()) {
                        ForkedBooter.this.logger.error("Surefire is going to kill self fork JVM. Maven process died.");
                        DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. Maven process died." + StringUtils.NL + "Thread dump before killing the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                        ForkedBooter.this.kill();
                    }
                }
                catch (RuntimeException e) {
                    DumpErrorSingleton.getSingleton().dumpException(e, "System.exit() or native command error interrupted process checker.");
                }
            }
        };
    }

    private CommandListener createPingHandler(final AtomicBoolean pingDone) {
        return new CommandListener(){

            @Override
            public void update(Command command) {
                pingDone.set(true);
            }
        };
    }

    private CommandListener createExitHandler(final PpidChecker ppidChecker) {
        return new CommandListener(){

            @Override
            public void update(Command command) {
                Shutdown shutdown = command.toShutdownData();
                if (shutdown.isKill()) {
                    if (ppidChecker != null) {
                        ppidChecker.stop();
                    }
                    ForkedBooter.this.logger.error("Surefire is going to kill self fork JVM. Received SHUTDOWN {" + (Object)((Object)shutdown) + "} command from Maven shutdown hook.");
                    DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. Received SHUTDOWN command from Maven shutdown hook." + StringUtils.NL + "Thread dump before killing the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                    ForkedBooter.this.kill();
                } else if (shutdown.isExit()) {
                    if (ppidChecker != null) {
                        ppidChecker.stop();
                    }
                    ForkedBooter.this.cancelPingScheduler();
                    ForkedBooter.this.logger.error("Surefire is going to exit self fork JVM. Received SHUTDOWN {" + (Object)((Object)shutdown) + "} command from Maven shutdown hook.");
                    DumpErrorSingleton.getSingleton().dumpText("Exiting self fork JVM. Received SHUTDOWN command from Maven shutdown hook." + StringUtils.NL + "Thread dump before exiting the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                    ForkedBooter.this.exitBarrier.release();
                    ForkedBooter.this.exit1();
                } else {
                    DumpErrorSingleton.getSingleton().dumpText("Thread dump for process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                }
            }
        };
    }

    private Runnable createPingJob(final AtomicBoolean pingDone, final PpidChecker pluginProcessChecker) {
        return new Runnable(){

            @Override
            public void run() {
                boolean hasPing;
                if (!ForkedBooter.canUseNewPingMechanism(pluginProcessChecker) && !(hasPing = pingDone.getAndSet(false))) {
                    ForkedBooter.this.logger.error("Killing self fork JVM. PING timeout elapsed.");
                    DumpErrorSingleton.getSingleton().dumpText("Killing self fork JVM. PING timeout elapsed." + StringUtils.NL + "Thread dump before killing the process (" + ForkedBooter.getProcessName() + "):" + StringUtils.NL + ForkedBooter.generateThreadDump());
                    ForkedBooter.this.kill();
                }
            }
        };
    }

    private void kill() {
        this.kill(1);
    }

    private void kill(int returnCode) {
        this.commandReader.stop();
        this.closeForkChannel();
        Runtime.getRuntime().halt(returnCode);
    }

    private void exit1() {
        this.launchLastDitchDaemonShutdownThread(1);
        System.exit(1);
    }

    private void acknowledgedExit() {
        this.commandReader.addByeAckListener(new CommandListener(){

            @Override
            public void update(Command command) {
                ForkedBooter.this.exitBarrier.release();
            }
        });
        this.eventChannel.bye();
        this.launchLastDitchDaemonShutdownThread(0);
        boolean byeAckReceived = ForkedBooter.acquireOnePermit(this.exitBarrier);
        if (!byeAckReceived && !this.eventChannel.checkError()) {
            this.eventChannel.sendExitError(null, false);
        }
        this.cancelPingScheduler();
        this.commandReader.stop();
        this.closeForkChannel();
        System.exit(0);
    }

    private void runSuitesInProcess() throws TestSetFailedException, InvocationTargetException {
        this.createProviderInCurrentClassloader().invoke(this.testSet);
    }

    private ForkingReporterFactory createForkingReporterFactory() {
        boolean trimStackTrace = this.providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return new ForkingReporterFactory(trimStackTrace, this.eventChannel);
    }

    private synchronized ScheduledThreadPoolExecutor getJvmTerminator() {
        if (this.jvmTerminator == null) {
            ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory(LAST_DITCH_SHUTDOWN_THREAD + this.systemExitTimeoutInSeconds + "s");
            this.jvmTerminator = new ScheduledThreadPoolExecutor(1, threadFactory);
            this.jvmTerminator.setMaximumPoolSize(1);
        }
        return this.jvmTerminator;
    }

    private void launchLastDitchDaemonShutdownThread(final int returnCode) {
        this.getJvmTerminator().schedule(new Runnable(){

            @Override
            public void run() {
                if (ForkedBooter.this.logger != null) {
                    ForkedBooter.this.logger.error("Surefire is going to kill self fork JVM. The exit has elapsed " + ForkedBooter.this.systemExitTimeoutInSeconds + " seconds after System.exit(" + returnCode + ").");
                }
                DumpErrorSingleton.getSingleton().dumpText("Thread dump for process (" + ForkedBooter.getProcessName() + ") after " + ForkedBooter.this.systemExitTimeoutInSeconds + " seconds shutdown timeout:" + StringUtils.NL + ForkedBooter.generateThreadDump());
                ForkedBooter.this.kill(returnCode);
            }
        }, this.systemExitTimeoutInSeconds, TimeUnit.SECONDS);
    }

    private SurefireProvider createProviderInCurrentClassloader() {
        BaseProviderFactory bpf = new BaseProviderFactory(true);
        bpf.setReporterFactory(this.forkingReporterFactory);
        bpf.setCommandReader(this.commandReader);
        bpf.setTestRequest(this.providerConfiguration.getTestSuiteDefinition());
        bpf.setReporterConfiguration(this.providerConfiguration.getReporterConfiguration());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        bpf.setClassLoaders(classLoader);
        bpf.setTestArtifactInfo(this.providerConfiguration.getTestArtifact());
        bpf.setProviderProperties(this.providerConfiguration.getProviderProperties());
        bpf.setRunOrderParameters(this.providerConfiguration.getRunOrderParameters());
        bpf.setDirectoryScannerParameters(this.providerConfiguration.getDirScannerParams());
        bpf.setMainCliOptions(this.providerConfiguration.getMainCliOptions());
        bpf.setSkipAfterFailureCount(this.providerConfiguration.getSkipAfterFailureCount());
        bpf.setSystemExitTimeout(this.providerConfiguration.getSystemExitTimeout());
        String providerClass = this.startupConfiguration.getActualClassName();
        return (SurefireProvider)ReflectionUtils.instantiateOneArg(classLoader, providerClass, ProviderParameters.class, bpf);
    }

    private void flushEventChannelOnExit() {
        Runnable target = new Runnable(){

            @Override
            public void run() {
                ForkedBooter.this.eventChannel.onJvmExit();
            }
        };
        Thread t = new Thread(target);
        t.setDaemon(true);
        ShutdownHookUtils.addShutDownHook(t);
    }

    private static MasterProcessChannelProcessorFactory lookupDecoderFactory(String channelConfig) {
        MasterProcessChannelProcessorFactory defaultFactory = null;
        MasterProcessChannelProcessorFactory customFactory = null;
        for (MasterProcessChannelProcessorFactory factory : ServiceLoader.load(MasterProcessChannelProcessorFactory.class)) {
            boolean isSurefireFactory;
            Class<?> cls = factory.getClass();
            boolean bl = isSurefireFactory = cls == LegacyMasterProcessChannelProcessorFactory.class || cls == SurefireMasterProcessChannelProcessorFactory.class;
            if (isSurefireFactory) {
                if (!factory.canUse(channelConfig)) continue;
                defaultFactory = factory;
                continue;
            }
            customFactory = factory;
        }
        return customFactory != null ? customFactory : defaultFactory;
    }

    public static void main(String[] args) {
        ForkedBooter booter = new ForkedBooter();
        ForkedBooter.run(booter, args);
    }

    private static void run(ForkedBooter booter, String[] args) {
        try {
            booter.setupBooter(args[0], args[1], args[2], args.length > 3 ? args[3] : null);
            booter.execute();
        }
        catch (Throwable t) {
            DumpErrorSingleton.getSingleton().dumpException(t);
            if (booter.logger != null) {
                booter.logger.error(t.getLocalizedMessage(), t);
            }
            booter.cancelPingScheduler();
            booter.exit1();
        }
    }

    private static boolean canUseNewPingMechanism(PpidChecker pluginProcessChecker) {
        return pluginProcessChecker != null && pluginProcessChecker.canUse();
    }

    private static boolean acquireOnePermit(Semaphore barrier) {
        try {
            return barrier.tryAcquire(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static ScheduledExecutorService createScheduler(String threadName) {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory(threadName);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setMaximumPoolSize(executor.getCorePoolSize());
        return executor;
    }

    private static InputStream createSurefirePropertiesIfFileExists(String tmpDir, String propFileName) throws FileNotFoundException {
        File surefirePropertiesFile = new File(tmpDir, propFileName);
        return surefirePropertiesFile.exists() ? new FileInputStream(surefirePropertiesFile) : null;
    }

    private static boolean isDebugging() {
        for (String argument : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!"-Xdebug".equals(argument) && !argument.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    private static String generateThreadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    private static String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    private static class PingScheduler {
        private final ScheduledExecutorService pingScheduler;
        private final ScheduledExecutorService processCheckerScheduler;
        private final PpidChecker processChecker;

        PingScheduler(ScheduledExecutorService pingScheduler, ScheduledExecutorService processCheckerScheduler, PpidChecker processChecker) {
            this.pingScheduler = pingScheduler;
            this.processCheckerScheduler = processCheckerScheduler;
            this.processChecker = processChecker;
        }

        void shutdown() {
            this.pingScheduler.shutdown();
            this.processCheckerScheduler.shutdown();
            if (this.processChecker != null) {
                this.processChecker.destroyActiveCommands();
            }
        }
    }
}

