/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.shared.lang3.JavaVersion;
import org.apache.maven.surefire.shared.lang3.StringUtils;

public final class SystemUtils {
    private static final BigDecimal JIGSAW_JAVA_VERSION = new BigDecimal(9).stripTrailingZeros();
    private static final int PROC_STATUS_PID_FIRST_CHARS = 20;

    private SystemUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static boolean endsWithJavaPath(String jvmExecPath) {
        File javaExec = new File(jvmExecPath).getAbsoluteFile();
        File bin = javaExec.getParentFile();
        String exec = javaExec.getName();
        return exec.startsWith("java") && bin != null && bin.getName().equals("bin");
    }

    public static File toJdkHomeFromJvmExec(String jvmExecutable) {
        File bin = new File(jvmExecutable).getAbsoluteFile().getParentFile();
        if ("bin".equals(bin.getName())) {
            File parent = bin.getParentFile();
            if ("jre".equals(parent.getName())) {
                File jdk = parent.getParentFile();
                return new File(jdk, "bin").isDirectory() ? jdk : null;
            }
            return parent;
        }
        return null;
    }

    public static File toJdkHomeFromJre() {
        return SystemUtils.toJdkHomeFromJre(System.getProperty("java.home"));
    }

    static File toJdkHomeFromJre(String jreHome) {
        File pathToJreOrJdk = new File(jreHome).getAbsoluteFile();
        return "jre".equals(pathToJreOrJdk.getName()) ? pathToJreOrJdk.getParentFile() : pathToJreOrJdk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BigDecimal toJdkVersionFromReleaseFile(File jdkHome) {
        File release = new File(Objects.requireNonNull(jdkHome).getAbsoluteFile(), "release");
        if (!release.isFile()) {
            return null;
        }
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(release);){
            properties.load(is);
            String javaVersion = properties.getProperty("JAVA_VERSION").replace("\"", "");
            StringTokenizer versions = new StringTokenizer(javaVersion, "._");
            if (versions.countTokens() == 1) {
                javaVersion = versions.nextToken();
            } else {
                if (versions.countTokens() < 2) {
                    BigDecimal bigDecimal2 = null;
                    return bigDecimal2;
                }
                String majorVersion = versions.nextToken();
                String minorVersion = versions.nextToken();
                javaVersion = StringUtils.isNumeric(minorVersion) ? majorVersion + "." + minorVersion : majorVersion;
            }
            BigDecimal bigDecimal = new BigDecimal(javaVersion);
            return bigDecimal;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isJava9AtLeast(String jvmExecutablePath) {
        File externalJavaHome = SystemUtils.toJdkHomeFromJvmExec(jvmExecutablePath);
        File thisJavaHome = SystemUtils.toJdkHomeFromJre();
        if (thisJavaHome.equals(externalJavaHome)) {
            return SystemUtils.isBuiltInJava9AtLeast();
        }
        BigDecimal releaseFileVersion = externalJavaHome == null ? null : SystemUtils.toJdkVersionFromReleaseFile(externalJavaHome);
        return SystemUtils.isJava9AtLeast(releaseFileVersion);
    }

    public static boolean isBuiltInJava9AtLeast() {
        return JavaVersion.JAVA_RECENT.atLeast(JavaVersion.JAVA_9);
    }

    public static boolean isJava9AtLeast(BigDecimal version) {
        return version != null && version.compareTo(JIGSAW_JAVA_VERSION) >= 0;
    }

    public static ClassLoader platformClassLoader() {
        if (SystemUtils.isBuiltInJava9AtLeast()) {
            return SystemUtils.reflectClassLoader(ClassLoader.class, "getPlatformClassLoader");
        }
        return null;
    }

    public static Long pid() {
        Long pid;
        if (SystemUtils.isBuiltInJava9AtLeast() && (pid = SystemUtils.pidOnJava9()) != null) {
            return pid;
        }
        if (org.apache.maven.surefire.shared.lang3.SystemUtils.IS_OS_LINUX) {
            try {
                return SystemUtils.pidStatusOnLinux();
            }
            catch (Exception exception) {
            }
        } else if (org.apache.maven.surefire.shared.lang3.SystemUtils.IS_OS_FREE_BSD || org.apache.maven.surefire.shared.lang3.SystemUtils.IS_OS_NET_BSD || org.apache.maven.surefire.shared.lang3.SystemUtils.IS_OS_OPEN_BSD) {
            try {
                return SystemUtils.pidStatusOnBSD();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SystemUtils.pidOnJMX();
    }

    static Long pidOnJMX() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (processName.contains("@")) {
            String pid = processName.substring(0, processName.indexOf(64)).trim();
            try {
                return Long.parseLong(pid);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    static Long pidStatusOnLinux() throws Exception {
        return SystemUtils.pidStatusOnLinux("");
    }

    static Long pidStatusOnLinux(String root) throws Exception {
        try (FileReader input = new FileReader(root + "/proc/self/stat");){
            char[] buffer = new char[20];
            String startLine = new String(buffer, 0, input.read(buffer));
            Long l = Long.parseLong(startLine.substring(0, startLine.indexOf(32)));
            return l;
        }
    }

    static Long pidStatusOnBSD() throws Exception {
        return SystemUtils.pidStatusOnBSD("");
    }

    static Long pidStatusOnBSD(String root) throws Exception {
        try (BufferedReader input = new BufferedReader(new FileReader(root + "/proc/curproc/status"));){
            String line = input.readLine();
            int i1 = 1 + line.indexOf(32);
            int i2 = line.indexOf(32, i1);
            Long l = Long.parseLong(line.substring(i1, i2));
            return l;
        }
    }

    static Long pidOnJava9() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> processHandle = ReflectionUtils.tryLoadClass(classLoader, "java.lang.ProcessHandle");
        Class[] classesChain = new Class[]{processHandle, processHandle};
        String[] methodChain = new String[]{"current", "pid"};
        return (Long)ReflectionUtils.invokeMethodChain(classesChain, methodChain, null);
    }

    static ClassLoader reflectClassLoader(Class<?> target, String getterMethodName) {
        try {
            Method getter = ReflectionUtils.getMethod(target, getterMethodName, new Class[0]);
            return (ClassLoader)ReflectionUtils.invokeMethodWithArray(null, getter, new Object[0]);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

