/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.tar;

import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class FilePermissionHelper {
    private static final int OWNER_READ_FILEMODE = 256;
    private static final int OWNER_WRITE_FILEMODE = 128;
    private static final int OWNER_EXEC_FILEMODE = 64;
    private static final int GROUP_READ_FILEMODE = 32;
    private static final int GROUP_WRITE_FILEMODE = 16;
    private static final int GROUP_EXEC_FILEMODE = 8;
    private static final int OTHERS_READ_FILEMODE = 4;
    private static final int OTHERS_WRITE_FILEMODE = 2;
    private static final int OTHERS_EXEC_FILEMODE = 1;

    private FilePermissionHelper() {
    }

    public static int toOctalFileMode(Set<PosixFilePermission> permissions) {
        int result = 0;
        for (PosixFilePermission permissionBit : permissions) {
            result |= (switch (permissionBit) {
                default -> throw new MatchException(null, null);
                case PosixFilePermission.OWNER_READ -> 256;
                case PosixFilePermission.OWNER_WRITE -> 128;
                case PosixFilePermission.OWNER_EXECUTE -> 64;
                case PosixFilePermission.GROUP_READ -> 32;
                case PosixFilePermission.GROUP_WRITE -> 16;
                case PosixFilePermission.GROUP_EXECUTE -> 8;
                case PosixFilePermission.OTHERS_READ -> 4;
                case PosixFilePermission.OTHERS_WRITE -> 2;
                case PosixFilePermission.OTHERS_EXECUTE -> 1;
            });
        }
        return result;
    }
}

