/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.BuildDirectory;
import org.eclipse.tycho.DependencySeed;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherServiceFactory;
import org.eclipse.tycho.plugins.p2.publisher.AbstractPublishMojo;

@Mojo(name="publish-categories", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class PublishCategoriesMojo
extends AbstractPublishMojo {
    @Component(role=TychoProject.class, hint="eclipse-repository")
    private EclipseRepositoryProject eclipseRepositoryProject;
    @Parameter(defaultValue="${project.basedir}")
    private File categoriesDirectory;

    @Override
    protected Collection<DependencySeed> publishContent(PublisherServiceFactory publisherServiceFactory) throws MojoExecutionException, MojoFailureException {
        PublisherService publisherService = publisherServiceFactory.createPublisher(this.getReactorProject(), this.getEnvironments());
        try {
            ArrayList<DependencySeed> categoryIUs = new ArrayList<DependencySeed>();
            for (Category category : this.getCategories(this.categoriesDirectory)) {
                File buildCategoryFile = this.prepareBuildCategory(category, this.getBuildDirectory());
                Collection ius = publisherService.publishCategories(buildCategoryFile);
                categoryIUs.addAll(ius);
            }
            return categoryIUs;
        }
        catch (FacadeException e) {
            throw new MojoExecutionException("Exception while publishing categories: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private File prepareBuildCategory(Category category, BuildDirectory buildFolder) throws MojoExecutionException {
        try {
            File ret = buildFolder.getChild("category.xml");
            buildFolder.getLocation().mkdirs();
            Category.write((Category)category, (File)ret);
            this.copySiteI18nFiles(buildFolder);
            this.copyP2Inf(buildFolder);
            return ret;
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O exception while writing category definition to disk", (Exception)e);
        }
    }

    private void copyP2Inf(BuildDirectory buildFolder) throws IOException {
        File p2inf = new File(this.getProject().getBasedir(), "p2.inf");
        if (p2inf.isFile()) {
            FileUtils.copyFile((File)p2inf, (File)buildFolder.getChild(p2inf.getName()));
        }
    }

    private void copySiteI18nFiles(BuildDirectory buildFolder) throws IOException {
        File[] i18nFiles = this.getProject().getBasedir().listFiles(file -> {
            String fileName = file.getName();
            return fileName.startsWith("site") && fileName.endsWith(".properties");
        });
        if (i18nFiles == null) {
            return;
        }
        for (File i18nFile : i18nFiles) {
            FileUtils.copyFile((File)i18nFile, (File)buildFolder.getChild(i18nFile.getName()));
        }
    }

    private List<Category> getCategories(File categoriesDirectory) {
        return this.eclipseRepositoryProject.loadCategories(categoriesDirectory);
    }
}

