/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.helper.StatusTool;
import org.eclipse.tycho.p2maven.repository.P2RepositoryKind;
import org.eclipse.tycho.p2maven.tools.P2RepositoryDataManipulator;

@Mojo(name="modify-repository-properties", threadSafe=true)
public class ModifyRepositoryPropertiesMojo
extends AbstractMojo {
    @Parameter
    private Repository repository;
    @Parameter(property="p2.repository.output")
    private Path outputLocation;
    @Parameter(property="p2.repository.kind")
    private P2RepositoryKind repositoryKind;
    @Parameter(property="p2.repository.name")
    private String repositoryName;
    @Parameter(property="p2.repository.properties.remove")
    private List<String> propertiesToRemove = List.of();
    @Parameter(property="p2.repository.properties.add")
    private Map<String, String> propertiesToAdd = Map.of();
    @Parameter(property="p2.repository.compress", defaultValue="true")
    private boolean compress;
    @Parameter(property="p2.repository.xz", defaultValue="true")
    private boolean xzCompress;
    @Parameter(property="p2.repository.xz.keep", defaultValue="true")
    private boolean keepNonXzIndexFiles;
    @Inject
    private P2RepositoryDataManipulator manipulator;
    @Inject
    private Logger log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Path output;
            P2RepositoryDataManipulator.ModifiedRepositoryDescriptor descriptor = P2RepositoryDataManipulator.createDescriptor((Repository)this.repository, (P2RepositoryKind)this.repositoryKind, (Path)this.outputLocation, (boolean)this.compress, (boolean)this.xzCompress, (boolean)this.keepNonXzIndexFiles);
            Object type = "repository";
            if (this.repositoryKind != null) {
                type = (this.repositoryKind == P2RepositoryKind.artifact ? "artifact" : "metadata") + " repository";
            }
            if ((output = descriptor.outputLocation()) != null) {
                this.log.info("Write modified " + (String)type + " file(s) to " + String.valueOf(output));
            } else {
                this.log.info("Modify " + (String)type + " in-place at " + String.valueOf(descriptor.repository().getURL()));
            }
            if (this.repositoryName != null) {
                this.log.info("Set name to: " + this.repositoryName);
            }
            if (!this.propertiesToRemove.isEmpty()) {
                this.log.info("Remove properties: " + String.join((CharSequence)", ", this.propertiesToRemove));
            }
            if (!this.propertiesToAdd.isEmpty()) {
                this.log.info("Add properties:");
                this.propertiesToAdd.forEach((key, value) -> this.log.info("  " + key + " = " + value));
            }
            this.manipulator.modifyRepositoryMetadata(descriptor, this.repositoryName, this.propertiesToRemove, this.propertiesToAdd);
        }
        catch (P2RepositoryDataManipulator.RepositoryLocationURISyntaxException e) {
            throw new MojoFailureException("Illegal repository location URL: " + this.repository.getUrl(), e.getCause());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to modify repository " + this.repository.getUrl(), (Exception)e);
        }
        catch (ProvisionException e) {
            this.log.error(StatusTool.toLogMessage((IStatus)e.getStatus()), (Throwable)e);
            throw new MojoExecutionException("Failed to modify repository " + this.repository.getUrl() + ": " + StatusTool.collectProblems((IStatus)e.getStatus()), (Exception)((Object)e));
        }
    }
}

