/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.transport.netty4.Netty4Transport;

public final class SharedGroupFactory {
    private static final Logger logger = LogManager.getLogger(SharedGroupFactory.class);
    private final Settings settings;
    private final int workerCount;
    private final int httpWorkerCount;
    private RefCountedGroup genericGroup;
    private SharedGroup dedicatedHttpGroup;

    public SharedGroupFactory(Settings settings) {
        this.settings = settings;
        this.workerCount = (Integer)Netty4Transport.WORKER_COUNT.get(settings);
        this.httpWorkerCount = (Integer)Netty4HttpServerTransport.SETTING_HTTP_WORKER_COUNT.get(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public int getTransportWorkerCount() {
        return this.workerCount;
    }

    public synchronized SharedGroup getTransportGroup() {
        return this.getGenericGroup();
    }

    public synchronized SharedGroup getHttpGroup() {
        if (this.httpWorkerCount == 0) {
            return this.getGenericGroup();
        }
        if (this.dedicatedHttpGroup == null) {
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(this.httpWorkerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker"));
            this.dedicatedHttpGroup = new SharedGroup(new RefCountedGroup((EventLoopGroup)eventLoopGroup));
        }
        return this.dedicatedHttpGroup;
    }

    private SharedGroup getGenericGroup() {
        if (this.genericGroup == null) {
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_worker"));
            this.genericGroup = new RefCountedGroup((EventLoopGroup)eventLoopGroup);
        } else {
            this.genericGroup.incRef();
        }
        return new SharedGroup(this.genericGroup);
    }

    public static class SharedGroup {
        private final RefCountedGroup refCountedGroup;
        private final AtomicBoolean isOpen = new AtomicBoolean(true);

        private SharedGroup(RefCountedGroup refCountedGroup) {
            this.refCountedGroup = refCountedGroup;
        }

        public EventLoopGroup getLowLevelGroup() {
            return this.refCountedGroup.eventLoopGroup;
        }

        public void shutdown() {
            if (this.isOpen.compareAndSet(true, false)) {
                this.refCountedGroup.decRef();
            }
        }
    }

    private static class RefCountedGroup
    extends AbstractRefCounted {
        public static final String NAME = "ref-counted-event-loop-group";
        private final EventLoopGroup eventLoopGroup;

        private RefCountedGroup(EventLoopGroup eventLoopGroup) {
            super(NAME);
            this.eventLoopGroup = eventLoopGroup;
        }

        protected void closeInternal() {
            Future shutdownFuture = this.eventLoopGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
            shutdownFuture.awaitUninterruptibly();
            if (!shutdownFuture.isSuccess()) {
                logger.warn("Error closing netty event loop group", shutdownFuture.cause());
            }
        }
    }
}

