/*
 * Decompiled with CFR 0.152.
 */
package org.eu.ingwar.tools.arquillian.extension.deployment;

import org.eu.ingwar.tools.arquillian.extension.deployment.EarDescriptorBuilder;
import org.eu.ingwar.tools.arquillian.extension.deployment.ModuleType;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.ResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.AcceptScopesStrategy;

public class EarGenericBuilder {
    private static final String RUN_AT_ARQUILLIAN_PATH = "/runs-at-arquillian.txt";
    private static final String RUN_AT_ARQUILLIAN_CONTENT = "at-arquillian";

    private EarGenericBuilder() {
    }

    public static EnterpriseArchive getModuleDeployment(ModuleType type) {
        return EarGenericBuilder.getModuleDeployment(type, type.generateModuleName());
    }

    public static EnterpriseArchive getModuleDeployment(ModuleType type, String basename) {
        return EarGenericBuilder.getModuleDeployment(type, basename, true);
    }

    public static EnterpriseArchive getModuleDeployment(ModuleType type, String basename, boolean doFiltering) {
        String name = basename + "." + type.getExtension();
        String testJarName = basename + "-tests.jar";
        try {
            MavenResolvedArtifact[] deps;
            MavenResolvedArtifact[] provided;
            EarDescriptorBuilder descriptorBuilder = new EarDescriptorBuilder(basename);
            MavenResolverSystem maven = Maven.resolver();
            EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)(basename + "-full.ear"));
            PomEquippedResolveStage resolveStage = (PomEquippedResolveStage)((PomlessResolveStage)maven.offline()).loadPomFromFile("pom.xml");
            for (MavenResolvedArtifact mra : provided = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)resolveStage.importRuntimeDependencies()).importDependencies(new ScopeType[]{ScopeType.PROVIDED})).resolve()).withMavenCentralRepo(false)).using((ResolutionStrategy)new AcceptScopesStrategy(new ScopeType[]{ScopeType.PROVIDED}))).asResolvedArtifact()) {
                System.out.println("Checking provided: " + mra.getCoordinate().toCanonicalForm());
                if (!EarGenericBuilder.isArtifactEjb(mra.getCoordinate())) continue;
                ear.addAsModule((Archive)mra.as(JavaArchive.class));
                descriptorBuilder.addEjb(mra.asFile().getName());
                block3: for (MavenArtifactInfo mai : mra.getDependencies()) {
                    if (EarGenericBuilder.isArtifactEjb(mai.getCoordinate())) continue;
                    for (MavenResolvedArtifact reqMra : provided) {
                        if (!reqMra.getCoordinate().toCanonicalForm().equals(mai.getCoordinate().toCanonicalForm())) continue;
                        ear.addAsLibrary(reqMra.asFile());
                        continue block3;
                    }
                }
            }
            for (MavenResolvedArtifact mra : deps = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)((MavenStrategyStage)((PomEquippedResolveStage)resolveStage.importRuntimeAndTestDependencies()).resolve()).withMavenCentralRepo(false)).withTransitivity()).asResolvedArtifact()) {
                MavenCoordinate mc = mra.getCoordinate();
                PackagingType packaging = mc.getPackaging();
                if (doFiltering && EarGenericBuilder.isFiltered(mc)) continue;
                System.out.println("Adding: " + mc.toCanonicalForm());
                if (EarGenericBuilder.isArtifactEjb(mc)) {
                    ear.addAsModule((Archive)mra.as(JavaArchive.class));
                    descriptorBuilder.addEjb(mra.asFile().getName());
                    continue;
                }
                if (packaging.equals((Object)PackagingType.WAR)) {
                    ear.addAsModule((Archive)mra.as(WebArchive.class));
                    descriptorBuilder.addWeb(mra.asFile().getName());
                    continue;
                }
                ear.addAsLibrary(mra.asFile());
            }
            Archive module = (Archive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)name)).importDirectory(type.getExplodedDir(basename)).as(type.getType());
            JavaArchive testJar = (JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)testJarName)).importDirectory("target/test-classes").as(JavaArchive.class);
            module = module.merge((Archive)testJar, type.getMergePoint());
            module.add((Asset)new StringAsset(RUN_AT_ARQUILLIAN_CONTENT), RUN_AT_ARQUILLIAN_PATH);
            System.out.println(module.toString(true));
            EarGenericBuilder.addMainModule(ear, type, module, descriptorBuilder);
            if (!descriptorBuilder.containsWar()) {
                String testModuleName = ModuleType.WAR.generateModuleName() + ".war";
                ear.addAsModule((Archive)ShrinkWrap.create(WebArchive.class, (String)testModuleName));
                descriptorBuilder.addWeb(testModuleName);
            }
            ear.setApplicationXML((Asset)new StringAsset(descriptorBuilder.render()));
            ear.addManifest();
            System.out.println(ear.toString(true));
            System.out.println(descriptorBuilder.render());
            return ear;
        }
        catch (IllegalArgumentException | ArchiveImportException | InvalidConfigurationFileException ex) {
            throw new IllegalStateException("B\u0142\u0105d tworzenia deploymentu [" + ex + "]", ex);
        }
    }

    private static boolean isArtifactEjb(MavenCoordinate artifactCoordinate) {
        if ("client".equals(artifactCoordinate.getClassifier())) {
            return false;
        }
        if (!artifactCoordinate.getGroupId().startsWith("pl.gov.coi")) {
            return false;
        }
        return artifactCoordinate.getArtifactId().toLowerCase().contains("ejb");
    }

    private static void addMainModule(EnterpriseArchive ear, ModuleType type, Archive<?> module, EarDescriptorBuilder descriptorBuilder) {
        if (type.isModule()) {
            ear.addAsModule(module);
            if (type == ModuleType.EJB) {
                descriptorBuilder.addEjb(module.getName());
            }
            if (type == ModuleType.WAR) {
                descriptorBuilder.addWeb(module.getName());
            }
        } else {
            ear.addAsLibrary(module);
        }
    }

    private static boolean isFiltered(MavenCoordinate artifactCoordinate) {
        if (artifactCoordinate.getGroupId().startsWith("org.jboss.shrinkwrap")) {
            return true;
        }
        return artifactCoordinate.getGroupId().startsWith("org.jboss.arquillian");
    }
}

