/*
 * Decompiled with CFR 0.152.
 */
package org.eu.ingwar.tools.arquillian.extension.deployment;

import java.util.Random;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public enum ModuleType {
    WAR("war"),
    EJB("ejb"),
    JAR("jar");

    private String type;

    private ModuleType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    private static ModuleType fromString(String packaging) {
        for (ModuleType moduleType : ModuleType.values()) {
            if (!moduleType.type.equals(packaging)) continue;
            return moduleType;
        }
        throw new IllegalArgumentException("Nieprawid\u0142owa warto\u015b\u0107 dla enuma: " + packaging);
    }

    public Class<? extends Archive<?>> getType() {
        switch (this) {
            case WAR: {
                return WebArchive.class;
            }
            case EJB: 
            case JAR: {
                return JavaArchive.class;
            }
        }
        throw new IllegalStateException("Illegal type for archive");
    }

    public boolean isModule() {
        return this != JAR;
    }

    public String getExtension() {
        switch (this) {
            case WAR: {
                return "war";
            }
            case EJB: 
            case JAR: {
                return "jar";
            }
        }
        throw new IllegalStateException("Illegal type for extension");
    }

    String generateModuleName() {
        String name;
        switch (this) {
            case WAR: {
                name = "war";
                break;
            }
            case EJB: {
                name = "ejb";
                break;
            }
            case JAR: {
                name = "jar";
                break;
            }
            default: {
                throw new IllegalStateException("Illegal type for extension");
            }
        }
        Random random = new Random();
        name = name + "_module_" + random.nextInt(Integer.MAX_VALUE);
        return name;
    }

    String getMergePoint() {
        if (this.equals((Object)WAR)) {
            return "WEB-INF/classes";
        }
        return "";
    }

    String getExplodedDir(String basename) {
        if (this.equals((Object)WAR)) {
            return "target/" + basename;
        }
        return "target/classes";
    }
}

