/*
 * Decompiled with CFR 0.152.
 */
package org.eu.ingwar.tools.arquillian.extension.suite;

import java.util.Set;
import java.util.concurrent.Callable;
import org.eu.ingwar.tools.arquillian.extension.suite.ExtendedSuiteContext;
import org.eu.ingwar.tools.arquillian.extension.suite.ExtendedSuiteContextImpl;
import org.eu.ingwar.tools.arquillian.extension.suite.annotations.ArquilianSuiteDeployment;
import org.eu.ingwar.tools.arquillian.extension.suite.annotations.ExtendedSuiteScoped;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.DeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.DeploymentEvent;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.spi.event.UnDeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.test.impl.client.deployment.event.GenerateDeployment;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ArquillianSuiteExtension
implements LoadableExtension {
    private static Class<?> deploymentClass;

    public void register(LoadableExtension.ExtensionBuilder builder) {
        deploymentClass = ArquillianSuiteExtension.getDeploymentClass();
        if (deploymentClass != null) {
            builder.observer(SuiteDeployer.class).context(ExtendedSuiteContextImpl.class);
        } else {
            System.err.println("WARNING: arquillian-suite-deployment: Cannot find class annotated with @ArquilianSuiteDeployment, will try normal way..");
        }
    }

    private static Class<?> getDeploymentClass() {
        Reflections reflections = new Reflections("", new Scanner[0]);
        Set results = reflections.getTypesAnnotatedWith(ArquilianSuiteDeployment.class, true);
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            for (Class type : results) {
                System.err.println("ERROR: arquillian-suite-deployment: Duplicated class annotated with @ArquilianSuiteDeployment: " + type.getName());
            }
            throw new IllegalStateException("Duplicated classess annotated with @ArquilianSuiteDeployment");
        }
        return (Class)results.iterator().next();
    }

    public static class SuiteDeployer {
        @Inject
        private Instance<ClassContext> classContext;
        @Inject
        @ClassScoped
        private InstanceProducer<DeploymentScenario> classDeploymentScenario;
        @Inject
        private Event<DeploymentEvent> deploymentEvent;
        @Inject
        private Instance<ExtendedSuiteContext> extendedSuiteContext;
        @Inject
        private Event<GenerateDeployment> generateDeploymentEvent;
        private boolean suiteDeploymentGenerated;
        private DeploymentScenario suiteDeploymentScenario;
        @ExtendedSuiteScoped
        @Inject
        private InstanceProducer<DeploymentScenario> suiteDeploymentScenarioInstanceProducer;

        public void blockDeployManagedDeployments(@Observes EventContext<DeployManagedDeployments> ignored) {
        }

        public void blockSubsquentGenerateDeployment(@Observes EventContext<GenerateDeployment> eventContext) {
            if (this.suiteDeploymentGenerated) {
                return;
            }
            eventContext.proceed();
            this.suiteDeploymentGenerated = true;
        }

        public void blockUnDeployManagedDeployments(@Observes EventContext<UnDeployManagedDeployments> ignored) {
        }

        public void deploy(final @Observes AfterStart event, final ContainerRegistry registry) {
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() {
                    for (Deployment d : SuiteDeployer.this.suiteDeploymentScenario.deployments()) {
                        SuiteDeployer.this.deploymentEvent.fire((Object)new DeployDeployment(SuiteDeployer.this.findContainer(registry, event.getDeployableContainer()), d));
                    }
                    ExtendedSuiteContext extendedSuiteContextLocal = (ExtendedSuiteContext)SuiteDeployer.this.extendedSuiteContext.get();
                    if (!extendedSuiteContextLocal.isActive()) {
                        extendedSuiteContextLocal.deactivate();
                    }
                    return null;
                }
            });
        }

        private void executeInClassScope(Callable<Void> call) {
            try {
                ((ClassContext)this.classContext.get()).activate((Object)deploymentClass);
                call.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not invoke operation", e);
            }
            finally {
                ((ClassContext)this.classContext.get()).deactivate();
            }
        }

        private Container findContainer(ContainerRegistry registry, DeployableContainer<?> deployable) {
            for (Container container : registry.getContainers()) {
                if (container.getDeployableContainer() != deployable) continue;
                return container;
            }
            return null;
        }

        public void startup(@Observes(precedence=-100) ManagerStarted event, ArquillianDescriptor descriptor) {
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        SuiteDeployer.this.generateDeploymentEvent.fire((Object)new GenerateDeployment(new TestClass(deploymentClass)));
                        SuiteDeployer.this.suiteDeploymentScenario = (DeploymentScenario)SuiteDeployer.this.classDeploymentScenario.get();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return null;
                }
            });
            ((ExtendedSuiteContext)this.extendedSuiteContext.get()).activate();
            this.suiteDeploymentScenarioInstanceProducer.set((Object)this.suiteDeploymentScenario);
        }

        public void undeploy(final @Observes BeforeStop event, final ContainerRegistry registry) {
            this.executeInClassScope(new Callable<Void>(){

                @Override
                public Void call() {
                    for (Deployment d : SuiteDeployer.this.suiteDeploymentScenario.deployments()) {
                        SuiteDeployer.this.deploymentEvent.fire((Object)new UnDeployDeployment(SuiteDeployer.this.findContainer(registry, event.getDeployableContainer()), d));
                    }
                    return null;
                }
            });
        }
    }
}

