/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.tmpselectors;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.AbstractReader;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;

public abstract class TemporarySelectorReader
extends AbstractReader<SocketAddress> {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected final int defaultBufferSize = 8192;
    protected final TemporarySelectorsEnabledTransport transport;

    public TemporarySelectorReader(TemporarySelectorsEnabledTransport transport) {
        this.transport = transport;
    }

    @Override
    public GrizzlyFuture<ReadResult<Buffer, SocketAddress>> read(Connection connection, Buffer message, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor) throws IOException {
        return this.read(connection, message, completionHandler, interceptor, connection.getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public GrizzlyFuture<ReadResult<Buffer, SocketAddress>> read(Connection connection, Buffer message, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor, long timeout, TimeUnit timeunit) throws IOException {
        if (connection == null || !(connection instanceof NIOConnection)) {
            return TemporarySelectorReader.failure(new IllegalStateException("Connection should be NIOConnection and cannot be null"), completionHandler);
        }
        NIOConnection nioConnection = (NIOConnection)connection;
        ReadResult<Buffer, Object> currentResult = ReadResult.create(connection, message, null, 0);
        try {
            int readBytes = this.read0(nioConnection, interceptor, currentResult, message, timeout, timeunit);
            if (readBytes > 0) {
                if (completionHandler != null) {
                    completionHandler.completed(currentResult);
                }
                if (interceptor != null) {
                    interceptor.intercept(2, connection, currentResult);
                }
                return ReadyFutureImpl.create(currentResult);
            }
            return TemporarySelectorReader.failure(new TimeoutException(), completionHandler);
        }
        catch (IOException e) {
            return TemporarySelectorReader.failure(e, completionHandler);
        }
    }

    private int read0(NIOConnection connection, Interceptor<ReadResult> interceptor, ReadResult<Buffer, SocketAddress> currentResult, Buffer buffer, long timeout, TimeUnit timeunit) throws IOException {
        boolean isCompleted = false;
        while (!isCompleted) {
            isCompleted = true;
            int readBytes = this.read0(connection, currentResult, buffer, timeout, timeunit);
            if (readBytes <= 0) {
                return -1;
            }
            if (interceptor == null) continue;
            isCompleted = (interceptor.intercept(1, null, currentResult) & 1) != 0;
        }
        return currentResult.getReadSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final int read0(NIOConnection connection, ReadResult<Buffer, SocketAddress> currentResult, Buffer buffer, long timeout, TimeUnit timeunit) throws IOException {
        Selector readSelector = null;
        SelectionKey key = null;
        SelectableChannel channel = connection.getChannel();
        long readTimeout = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        try {
            int bytesRead = this.readNow0(connection, buffer, currentResult);
            if (bytesRead == 0) {
                readSelector = this.transport.getTemporarySelectorIO().getSelectorPool().poll();
                if (readSelector == null) {
                    int n = bytesRead;
                    this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
                    return n;
                }
                key = channel.register(readSelector, 1);
                key.interestOps(key.interestOps() | 1);
                int code = readSelector.select(readTimeout);
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
                if (code == 0) {
                    int n = bytesRead;
                    this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
                    return n;
                }
                bytesRead = this.readNow0(connection, buffer, currentResult);
            }
            if (bytesRead == -1) {
                throw new EOFException();
            }
            this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
            return bytesRead;
        }
        catch (Throwable throwable) {
            this.transport.getTemporarySelectorIO().recycleTemporaryArtifacts(readSelector, key);
            throw throwable;
        }
    }

    protected abstract int readNow0(NIOConnection var1, Buffer var2, ReadResult<Buffer, SocketAddress> var3) throws IOException;

    protected Buffer acquireBuffer(Connection connection) {
        Transport connectionTransport = connection.getTransport();
        return connectionTransport.getMemoryManager().allocate(8192);
    }

    public TemporarySelectorsEnabledTransport getTransport() {
        return this.transport;
    }

    private static GrizzlyFuture<ReadResult<Buffer, SocketAddress>> failure(Throwable failure, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler) {
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
        return ReadyFutureImpl.create(failure);
    }
}

