/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.jsr330;

import com.sun.hk2.jsr330.Jsr330BindingExt;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import org.jvnet.hk2.component.MultiMap;

public class BasicBinding
implements Jsr330BindingExt,
Cloneable {
    private String service;
    private List<String> contracts;
    private List<Named> names;
    private List<Class<? extends Annotation>> qualifiers;
    private Scope scope;
    private MultiMap<String, String> metadata;

    public BasicBinding() {
    }

    public BasicBinding(String service) {
        this.setServiceClassName(service);
    }

    public BasicBinding(Class<?> service) {
        this.setServiceClass(service);
    }

    public BasicBinding(Jsr330BindingExt another) {
        this.copy(another);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getServiceClassName() + ", indicies: " + this.getContractClassNames() + ", names: " + this.getServiceNames() + ", qualifiers: " + this.getServiceQualifiers() + ")";
    }

    public BasicBinding clone() {
        BasicBinding clone = new BasicBinding();
        clone.copy(this);
        return clone;
    }

    protected synchronized void copy(Jsr330BindingExt another) {
        Collection<Class<? extends Annotation>> otherQualifiers;
        Collection<Named> otherNamed;
        this.service = another.getServiceClassName();
        if (null == this.service || this.service.isEmpty()) {
            throw new IllegalStateException();
        }
        Collection<String> other = another.getContractClassNames();
        if (null != other) {
            if (null == this.contracts) {
                this.contracts = new ArrayList<String>();
            }
            this.contracts.addAll(other);
        }
        if (null != (otherNamed = another.getServiceNames())) {
            if (null == this.names) {
                this.names = new ArrayList<Named>();
            }
            this.names.addAll(otherNamed);
        }
        if (null != (otherQualifiers = another.getServiceQualifiers())) {
            if (null == this.qualifiers) {
                this.qualifiers = new ArrayList<Class<? extends Annotation>>();
            }
            this.qualifiers.addAll(otherQualifiers);
        }
        this.scope = another.getServiceScope();
        MultiMap<String, String> otherMd = another.getMetadata();
        if (null != otherMd) {
            this.metadata = this.metadata.clone();
        }
    }

    @Override
    public String getServiceClassName() {
        return this.service;
    }

    public BasicBinding setServiceClassName(String service) {
        if (null == service || service.isEmpty()) {
            throw new IllegalStateException();
        }
        this.service = service;
        return this;
    }

    public BasicBinding setServiceClass(Class<?> service) {
        if (null == service) {
            throw new IllegalStateException();
        }
        this.service = service.getName();
        return this;
    }

    @Override
    public Collection<String> getContractClassNames() {
        return null == this.contracts ? null : Collections.unmodifiableList(this.contracts);
    }

    public synchronized BasicBinding addContractClassName(String contract) {
        if (null == contract || contract.isEmpty()) {
            throw new IllegalStateException();
        }
        if (null == this.contracts) {
            this.contracts = new ArrayList<String>();
        }
        this.contracts.add(contract);
        return this;
    }

    public BasicBinding addContractClass(Class<?> contract) {
        if (null == contract) {
            throw new IllegalStateException();
        }
        return this.addContractClassName(contract.getName());
    }

    @Override
    public Collection<Named> getServiceNames() {
        return null == this.names ? null : Collections.unmodifiableList(this.names);
    }

    public synchronized BasicBinding addName(Named named) {
        if (null == named) {
            throw new IllegalStateException();
        }
        if (null == this.names) {
            this.names = new ArrayList<Named>();
        }
        this.names.add(named);
        return this;
    }

    public synchronized BasicBinding addName(final String name) {
        if (null == name) {
            throw new IllegalStateException();
        }
        if (null == this.names) {
            this.names = new ArrayList<Named>();
        }
        this.names.add(new Named(){

            public String value() {
                return name;
            }

            public Class<? extends Annotation> annotationType() {
                return Named.class;
            }

            public String toString() {
                return this.value();
            }
        });
        return this;
    }

    @Override
    public Collection<Class<? extends Annotation>> getServiceQualifiers() {
        return null == this.qualifiers ? null : Collections.unmodifiableList(this.qualifiers);
    }

    public BasicBinding addQualifier(Class<? extends Annotation> qc) {
        Qualifier q = qc.getAnnotation(Qualifier.class);
        if (null == q) {
            throw new IllegalArgumentException(qc.getName());
        }
        if (null == this.qualifiers) {
            this.qualifiers = new ArrayList<Class<? extends Annotation>>();
        }
        this.qualifiers.add(qc);
        return this;
    }

    @Override
    public Scope getServiceScope() {
        return this.scope;
    }

    public void setServiceScope(Scope scope) {
        this.scope = scope;
    }

    @Override
    public MultiMap<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetaData(MultiMap<String, String> metadata) {
        this.metadata = null == metadata ? null : metadata.clone();
    }
}

