/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import org.glassfish.hk2.RunLevelDefaultScope;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantActivator;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.InhabitantSorter;
import org.jvnet.hk2.component.RunLevelListener;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.RunLevelState;
import org.jvnet.hk2.component.internal.runlevel.DefaultRunLevelService;

public abstract class AbstractRunLevelService<T>
implements RunLevelService<T>,
InhabitantListener {
    @Inject
    private Habitat habitat;
    private final Class<?> targetScope;
    private volatile DefaultRunLevelService delegate;

    protected AbstractRunLevelService(Class<?> targetScope) {
        if (null == targetScope || RunLevelDefaultScope.class == targetScope) {
            throw new IllegalStateException("invalid target scope");
        }
        this.targetScope = targetScope;
    }

    public String toString() {
        return this.getClass().getName() + "-" + System.identityHashCode(this) + "(" + this.delegate + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunLevelService<T> getDelegate() {
        if (null == this.delegate) {
            if (null == this.habitat) {
                throw new IllegalStateException("habitat was not initialized");
            }
            AbstractRunLevelService abstractRunLevelService = this;
            synchronized (abstractRunLevelService) {
                if (null == this.delegate) {
                    this.delegate = new DefaultRunLevelService(this.habitat, false, this.targetScope.getName(), this.targetScope, null);
                    this.delegate.setParent(this);
                }
            }
        }
        return this.delegate;
    }

    protected DefaultRunLevelService getDefault() {
        RunLevelService<T> rls = this.getDelegate();
        if (!DefaultRunLevelService.class.isInstance(rls)) {
            throw new UnsupportedOperationException();
        }
        return (DefaultRunLevelService)DefaultRunLevelService.class.cast(rls);
    }

    public void setListener(RunLevelListener listener) {
        this.getDefault().setListener(listener);
    }

    public void setInhabitantSorter(InhabitantSorter sorter) {
        this.getDefault().setInhabitantSorter(sorter);
    }

    public void setInhabitantActivator(InhabitantActivator activator) {
        this.getDefault().setInhabitantActivator(activator);
    }

    @Override
    public RunLevelState<T> getState() {
        return this.getDelegate().getState();
    }

    @Override
    public void proceedTo(int runLevel) {
        this.getDelegate().proceedTo(runLevel);
    }

    @Override
    public void interrupt() {
        this.getDelegate().interrupt();
    }

    @Override
    public void interrupt(int runLevel) {
        this.getDelegate().interrupt(runLevel);
    }

    @Override
    public boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        return this.getDefault().inhabitantChanged(eventType, inhabitant);
    }
}

