/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import java.net.URI;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.jetty.JettyHttpContainer;
import org.glassfish.jersey.jetty.internal.LocalizationMessages;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public final class JettyHttpContainerFactory {
    private JettyHttpContainerFactory() {
    }

    public static Server createServer(URI uri) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, true);
    }

    public static Server createServer(URI uri, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, start);
    }

    public static Server createServer(URI uri, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = (JettyHttpContainer)((Object)ContainerFactory.createContainer(JettyHttpContainer.class, (Application)config));
        return JettyHttpContainerFactory.createServer(uri, null, container, true);
    }

    public static Server createServer(URI uri, ResourceConfig configuration, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, (JettyHttpContainer)((Object)ContainerFactory.createContainer(JettyHttpContainer.class, (Application)configuration)), start);
    }

    public static Server createServer(URI uri, ResourceConfig config, boolean start, ServiceLocator parentLocator) {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer((Application)config, parentLocator), start);
    }

    public static Server createServer(URI uri, ResourceConfig config, ServiceLocator parentLocator) {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer((Application)config, parentLocator), true);
    }

    public static Server createServer(URI uri, SslContextFactory sslContextFactory, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = (JettyHttpContainer)((Object)ContainerFactory.createContainer(JettyHttpContainer.class, (Application)config));
        return JettyHttpContainerFactory.createServer(uri, sslContextFactory, container, true);
    }

    public static Server createServer(URI uri, SslContextFactory sslContextFactory, JettyHttpContainer handler, boolean start) {
        if (uri == null) {
            throw new IllegalArgumentException(LocalizationMessages.URI_CANNOT_BE_NULL());
        }
        String scheme = uri.getScheme();
        int defaultPort = 80;
        if (sslContextFactory == null) {
            if (!"http".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTP());
            }
        } else {
            if (!"https".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTPS());
            }
            defaultPort = 443;
        }
        int port = uri.getPort() == -1 ? defaultPort : uri.getPort();
        Server server = new Server();
        HttpConfiguration config = new HttpConfiguration();
        if (sslContextFactory != null) {
            config.setSecureScheme("https");
            config.setSecurePort(port);
            config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(config)});
            https.setPort(port);
            server.setConnectors(new Connector[]{https});
        } else {
            ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
            http.setPort(port);
            server.setConnectors(new Connector[]{http});
        }
        if (handler != null) {
            server.setHandler((Handler)handler);
        }
        if (start) {
            try {
                server.start();
            }
            catch (Exception e) {
                throw new ProcessingException(LocalizationMessages.ERROR_WHEN_CREATING_SERVER(), (Throwable)e);
            }
        }
        return server;
    }
}

