/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.UseSerialGC;
import com.oracle.svm.core.heap.PhysicalMemory;

@TargetClass(value=Runtime.class, onlyWith={UseSerialGC.class})
final class Target_java_lang_Runtime {
    Target_java_lang_Runtime() {
    }

    @Substitute
    private long freeMemory() {
        return this.maxMemory() - HeapImpl.getHeapImpl().getUsedBytes().rawValue();
    }

    @Substitute
    private long totalMemory() {
        return this.maxMemory();
    }

    @Substitute
    private long maxMemory() {
        PhysicalMemory.size();
        return HeapPolicy.getMaximumHeapSize().rawValue();
    }

    @Substitute
    private void gc() {
        HeapPolicy.maybeCauseUserRequestedCollection();
    }
}

