/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.graal.BarrierSnippets;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UnsignedUtils;
import java.lang.ref.Reference;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class CardTable {
    public static final int BYTES_COVERED_BY_ENTRY = 512;
    private static final int ENTRY_SIZE_BYTES = 1;
    private static final int DIRTY_ENTRY = 0;
    private static final int CLEAN_ENTRY = 1;
    private static final CardTableVerificationVisitor CARD_TABLE_VERIFICATION_VISITOR = new CardTableVerificationVisitor();

    private CardTable() {
    }

    public static void cleanTable(Pointer tableStart, UnsignedWord size) {
        UnmanagedMemoryUtil.fill(tableStart, size, (byte)1);
    }

    public static void setDirty(Pointer table, UnsignedWord index) {
        table.writeByte((WordBase)CardTable.indexToTableOffset(index), (byte)0, BarrierSnippets.CARD_REMEMBERED_SET_LOCATION);
    }

    public static void setClean(Pointer table, UnsignedWord index) {
        table.writeByte((WordBase)CardTable.indexToTableOffset(index), (byte)1, BarrierSnippets.CARD_REMEMBERED_SET_LOCATION);
    }

    public static boolean isDirty(Pointer table, UnsignedWord index) {
        int entry = CardTable.readEntry(table, index);
        return entry == 0;
    }

    private static boolean isClean(Pointer table, UnsignedWord index) {
        int entry = CardTable.readEntry(table, index);
        return entry == 1;
    }

    private static int readEntry(Pointer table, UnsignedWord index) {
        return table.readByte((WordBase)CardTable.indexToTableOffset(index));
    }

    private static UnsignedWord indexToTableOffset(UnsignedWord index) {
        return index.multiply(1);
    }

    public static UnsignedWord memoryOffsetToIndex(UnsignedWord offset) {
        return offset.unsignedDivide(512);
    }

    public static Pointer indexToMemoryPointer(Pointer memoryStart, UnsignedWord index) {
        UnsignedWord offset = index.multiply(512);
        return memoryStart.add(offset);
    }

    public static UnsignedWord tableSizeForMemorySize(UnsignedWord memorySize) {
        UnsignedWord maxIndex = CardTable.indexLimitForMemorySize(memorySize);
        return maxIndex.multiply(1);
    }

    public static UnsignedWord indexLimitForMemorySize(UnsignedWord memorySize) {
        UnsignedWord roundedMemory = UnsignedUtils.roundUp(memorySize, WordFactory.unsigned((int)512));
        return CardTable.memoryOffsetToIndex(roundedMemory);
    }

    public static boolean verify(Pointer cardTableStart, Pointer objectsStart, Pointer objectsLimit) {
        boolean success = true;
        Pointer curPtr = objectsStart;
        while (curPtr.belowThan((UnsignedWord)objectsLimit)) {
            Object obj = curPtr.toObject();
            UnsignedWord cardTableIndex = CardTable.memoryOffsetToIndex((UnsignedWord)curPtr.subtract((UnsignedWord)objectsStart));
            if (CardTable.isClean(cardTableStart, cardTableIndex)) {
                CARD_TABLE_VERIFICATION_VISITOR.initialize(obj, cardTableStart, objectsStart);
                InteriorObjRefWalker.walkObject(obj, CARD_TABLE_VERIFICATION_VISITOR);
                success &= CARD_TABLE_VERIFICATION_VISITOR.success;
                DynamicHub hub = KnownIntrinsics.readHub(obj);
                if (hub.isReferenceInstanceClass()) {
                    Reference ref = (Reference)obj;
                    success &= CardTable.verifyReferent(ref, cardTableStart, objectsStart);
                }
            }
            curPtr = LayoutEncoding.getObjectEnd(obj);
        }
        return success;
    }

    private static boolean verifyReferent(Reference<?> ref, Pointer cardTableStart, Pointer objectsStart) {
        return CardTable.verifyReference(ref, cardTableStart, objectsStart, ReferenceInternals.getReferentFieldAddress(ref), ReferenceInternals.getReferentPointer(ref));
    }

    private static boolean verifyReference(Object parentObject, Pointer cardTableStart, Pointer objectsStart, Pointer reference, Pointer referencedObject) {
        Object obj;
        HeapChunk.Header<?> objChunk;
        Space chunkSpace;
        if (referencedObject.isNonNull() && !HeapImpl.getHeapImpl().isInImageHeap(referencedObject) && (chunkSpace = HeapChunk.getSpace(objChunk = HeapChunk.getEnclosingHeapChunk(obj = referencedObject.toObject()))).isYoungSpace()) {
            UnsignedWord cardTableIndex = CardTable.memoryOffsetToIndex((UnsignedWord)Word.objectToUntrackedPointer((Object)parentObject).subtract((UnsignedWord)objectsStart));
            Pointer cardTableAddress = cardTableStart.add(CardTable.indexToTableOffset(cardTableIndex));
            Log.log().string("Object ").hex((WordBase)Word.objectToUntrackedPointer((Object)parentObject)).string(" (").string(parentObject.getClass().getName()).string(") has an object reference at ").hex((WordBase)reference).string(" that points to ").hex((WordBase)referencedObject).string(" (").string(obj.getClass().getName()).string("), which is in the young generation. However, the card table at ").hex((WordBase)cardTableAddress).string(" is clean.").newline();
            return false;
        }
        return true;
    }

    private static class CardTableVerificationVisitor
    implements ObjectReferenceVisitor {
        private Object parentObject;
        private Pointer cardTableStart;
        private Pointer objectsStart;
        private boolean success;

        private CardTableVerificationVisitor() {
        }

        public void initialize(Object parentObject, Pointer cardTableStart, Pointer objectsStart) {
            this.parentObject = parentObject;
            this.cardTableStart = cardTableStart;
            this.objectsStart = objectsStart;
            this.success = true;
        }

        @Override
        @SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT"}, justification="Non-short circuit logic is used on purpose here.")
        public boolean visitObjectReference(Pointer reference, boolean compressed) {
            Word referencedObject = ReferenceAccess.singleton().readObjectAsUntrackedPointer(reference, compressed);
            this.success &= CardTable.verifyReference(this.parentObject, this.cardTableStart, this.objectsStart, reference, (Pointer)referencedObject);
            return true;
        }
    }
}

