/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;

@TargetClass(className="sun.management.ManagementFactoryHelper")
final class Target_sun_management_ManagementFactoryHelper {
    Target_sun_management_ManagementFactoryHelper() {
    }

    @Substitute
    private static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementSupport.getSingleton().getPlatformMXBean(ClassLoadingMXBean.class);
    }

    @Substitute
    private static MemoryMXBean getMemoryMXBean() {
        return ManagementSupport.getSingleton().getPlatformMXBean(MemoryMXBean.class);
    }

    @Substitute
    private static ThreadMXBean getThreadMXBean() {
        return ManagementSupport.getSingleton().getPlatformMXBean(ThreadMXBean.class);
    }

    @Substitute
    private static RuntimeMXBean getRuntimeMXBean() {
        return ManagementSupport.getSingleton().getPlatformMXBean(RuntimeMXBean.class);
    }

    @Substitute
    private static CompilationMXBean getCompilationMXBean() {
        return ManagementSupport.getSingleton().getPlatformMXBean(CompilationMXBean.class);
    }

    @Substitute
    private static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementSupport.getSingleton().getPlatformMXBean(OperatingSystemMXBean.class);
    }

    @Substitute
    private static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementSupport.getSingleton().getPlatformMXBeans(MemoryPoolMXBean.class);
    }

    @Substitute
    private static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementSupport.getSingleton().getPlatformMXBeans(MemoryManagerMXBean.class);
    }

    @Substitute
    private static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementSupport.getSingleton().getPlatformMXBeans(GarbageCollectorMXBean.class);
    }

    @Substitute
    private static PlatformLoggingMXBean getPlatformLoggingMXBean() {
        return null;
    }

    @TargetElement(onlyWith={JDK11OrLater.class})
    @Substitute
    private static boolean isPlatformLoggingMXBeanAvailable() {
        return false;
    }
}

