/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.libc.LibC;
import com.oracle.svm.core.posix.headers.linux.LinuxErrno;
import com.oracle.svm.core.posix.linux.LinuxCErrorNumberSupport;
import com.oracle.svm.core.posix.linux.libc.BionicLibC;

@LibC(value={BionicLibC.class})
class BionicCErrorNumberSupport
extends LinuxCErrorNumberSupport {
    BionicCErrorNumberSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getCErrorNumber() {
        return LinuxErrno.__errno().read();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setCErrorNumber(int value) {
        LinuxErrno.__errno().write(value);
    }
}

