/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.stack.StackFrameVisitor;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public abstract class JavaStackFrameVisitor
extends StackFrameVisitor {
    @Override
    public final boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
        if (deoptimizedFrame != null) {
            for (DeoptimizedFrame.VirtualFrame frame = deoptimizedFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                if (this.visitFrame(frame.getFrameInfo())) continue;
                return false;
            }
        } else {
            CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip);
            for (FrameInfoQueryResult frameInfo = queryResult.getFrameInfo(); frameInfo != null; frameInfo = frameInfo.getCaller()) {
                if (this.visitFrame(frameInfo)) continue;
                return false;
            }
        }
        return true;
    }

    public abstract boolean visitFrame(FrameInfoQueryResult var1);
}

