/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK14OrLater;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.LoomJDK;
import com.oracle.svm.core.jdk.NotLoomJDK;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaContinuations;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.Target_java_lang_Continuation;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_java_lang_Thread_ThreadIdentifiers;
import com.oracle.svm.core.thread.ThreadIdRecomputation;
import com.oracle.svm.core.thread.ThreadStatusRecomputation;
import com.oracle.svm.core.util.VMError;
import java.security.AccessControlContext;
import java.util.Map;
import java.util.Objects;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.IsolateThread;

@TargetClass(value=Thread.class)
public final class Target_java_lang_Thread {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    IsolateThread isolateThread;
    @Inject
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile boolean interrupted;
    @Alias
    @TargetElement(name="interrupted", onlyWith={JDK14OrLater.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile boolean interruptedJDK14OrLater;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    boolean wasStartedByCurrentIsolate;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=UninterruptibleUtils.AtomicReference.class)
    UninterruptibleUtils.AtomicReference<ParkEvent> unsafeParkEvent;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=UninterruptibleUtils.AtomicReference.class)
    UninterruptibleUtils.AtomicReference<ParkEvent> sleepParkEvent;
    @Alias
    ClassLoader contextClassLoader;
    @Alias
    volatile String name;
    @Alias
    @TargetElement(onlyWith={NotLoomJDK.class})
    int priority;
    @Alias
    @TargetElement(onlyWith={NotLoomJDK.class})
    boolean daemon;
    @Alias
    @TargetElement(onlyWith={NotLoomJDK.class})
    Runnable target;
    @Alias
    @TargetElement(onlyWith={NotLoomJDK.class})
    ThreadGroup group;
    @Alias
    @TargetElement(onlyWith={NotLoomJDK.class})
    long stackSize;
    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    Target_java_lang_Thread_FieldHolder holder;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThreadIdRecomputation.class)
    long tid;
    @Delete
    @TargetElement(onlyWith={NotLoomJDK.class})
    static long threadSeqNumber;
    @Delete
    static int threadInitNumber;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private AccessControlContext inheritedAccessControlContext;
    @Alias
    @TargetElement(onlyWith={NotLoomJDK.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThreadStatusRecomputation.class)
    volatile int threadStatus;
    @Alias
    @TargetElement(onlyWith={NotLoomJDK.class})
    Object blockerLock;
    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    Object interruptLock;
    @Inject
    @TargetElement(onlyWith={LoomJDK.class})
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Thread vthread = null;
    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    Target_java_lang_Continuation cont;

    @Alias
    native void setPriority(int var1);

    @Substitute
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Substitute
    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    @Substitute
    @TargetElement(onlyWith={NotLoomJDK.class})
    static long nextThreadID() {
        return JavaThreads.singleton().threadSeqNumber.incrementAndGet();
    }

    @Substitute
    private static int nextThreadNum() {
        return JavaThreads.singleton().threadInitNumber.incrementAndGet();
    }

    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    public native boolean isVirtual();

    @Alias
    public native void exit();

    Target_java_lang_Thread(String withName, ThreadGroup withGroup, boolean asDaemon) {
        this.unsafeParkEvent = new UninterruptibleUtils.AtomicReference();
        this.sleepParkEvent = new UninterruptibleUtils.AtomicReference();
        JavaContinuations.LoomCompatibilityUtil.initThreadFields(this, withGroup != null ? withGroup : JavaThreads.singleton().mainGroup, null, 0L, 5, asDaemon, 5);
        if (JavaContinuations.useLoom()) {
            this.tid = Target_java_lang_Thread_ThreadIdentifiers.next();
        } else {
            this.tid = Target_java_lang_Thread.nextThreadID();
            this.blockerLock = new Object();
        }
        this.name = withName != null ? withName : "System-" + Target_java_lang_Thread.nextThreadNum();
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @Substitute
    public long getId() {
        return this.tid;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @Substitute
    public boolean isDaemon() {
        return this.daemon;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @Substitute
    @TargetElement(onlyWith={NotLoomJDK.class})
    static Thread currentThread() {
        return JavaThreads.currentThread.get();
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    private static Thread currentThread0() {
        return JavaThreads.currentThread.get();
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    @Substitute
    @TargetElement(name="currentThread", onlyWith={LoomJDK.class})
    static Thread currentVThread() {
        Target_java_lang_Thread thread = SubstrateUtil.cast(Target_java_lang_Thread.currentThread0(), Target_java_lang_Thread.class);
        if (thread.vthread != null) {
            return thread.vthread;
        }
        return SubstrateUtil.cast(thread, Thread.class);
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    void setCurrentThread(Thread thread) {
        Thread currentCarrierThread = Target_java_lang_Thread.currentThread0();
        assert (SubstrateUtil.cast(currentCarrierThread, Target_java_lang_Thread.class) == this);
        this.vthread = thread == currentCarrierThread ? null : thread;
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private void init(ThreadGroup groupArg, Runnable targetArg, String nameArg, long stackSizeArg) {
        this.unsafeParkEvent = new UninterruptibleUtils.AtomicReference();
        this.sleepParkEvent = new UninterruptibleUtils.AtomicReference();
        JavaThreads.initializeNewThread(this, groupArg, targetArg, nameArg, stackSizeArg);
    }

    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    private static native void checkCharacteristics(int var0);

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class, NotLoomJDK.class})
    private Target_java_lang_Thread(ThreadGroup g, Runnable target, String name, long stackSize, AccessControlContext acc, boolean inheritThreadLocals) {
        this.blockerLock = new Object();
        this.unsafeParkEvent = new UninterruptibleUtils.AtomicReference();
        this.sleepParkEvent = new UninterruptibleUtils.AtomicReference();
        JavaThreads.initializeNewThread(this, g, target, name, stackSize);
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    private Target_java_lang_Thread(ThreadGroup g, String name, int characteristics, Runnable target, long stackSize, AccessControlContext acc) {
        this.interruptLock = new Object();
        this.unsafeParkEvent = new UninterruptibleUtils.AtomicReference();
        this.sleepParkEvent = new UninterruptibleUtils.AtomicReference();
        Target_java_lang_Thread.checkCharacteristics(characteristics);
        JavaThreads.initializeNewThread(this, g, target, name, stackSize);
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    private Target_java_lang_Thread(String name, int characteristics) {
        this.interruptLock = new Object();
        this.name = name != null ? name : "<unnamed>";
        this.tid = Target_java_lang_Thread_ThreadIdentifiers.next();
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Substitute
    private void start0() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            throw VMError.unsupportedFeature("Single-threaded VM cannot create new threads");
        }
        long chosenStackSize = SubstrateOptions.StackSize.getHostedValue();
        long stackSize = JavaContinuations.LoomCompatibilityUtil.getStackSize(this);
        if (stackSize != 0L) {
            chosenStackSize = stackSize;
        } else {
            int defaultThreadStackSize = (int)XOptions.getXss().getValue();
            if ((long)defaultThreadStackSize != 0L) {
                chosenStackSize = defaultThreadStackSize;
            }
        }
        if (chosenStackSize != 0L) {
            chosenStackSize += (long)StackOverflowCheck.singleton().yellowAndRedZoneSize();
        }
        JavaContinuations.LoomCompatibilityUtil.setThreadStatus(this, 5);
        this.wasStartedByCurrentIsolate = true;
        JavaThreads.singleton().startThread(JavaThreads.fromTarget(this), chosenStackSize);
    }

    @Substitute
    protected void setNativeName(String name) {
        JavaThreads.singleton().setNativeName(JavaThreads.fromTarget(this), name);
    }

    @Substitute
    private void setPriority0(int priority) {
    }

    @Alias
    public native boolean isInterrupted();

    @Substitute
    @TargetElement(onlyWith={JDK11OrEarlier.class})
    private boolean isInterrupted(boolean clearInterrupted) {
        boolean result = this.interrupted;
        if (result && clearInterrupted) {
            this.interrupted = false;
        }
        return result;
    }

    @Substitute
    void interrupt0() {
        if (JavaVersionUtil.JAVA_SPEC <= 11) {
            this.interrupted = true;
        }
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        Thread thread = JavaThreads.fromTarget(this);
        JavaThreads.interrupt(thread);
        JavaThreads.unpark(thread);
        JavaThreads.wakeUpVMConditionWaiters(thread);
    }

    @Substitute
    private void stop0(Object o) {
        throw VMError.unsupportedFeature("The deprecated method Thread.stop is not supported");
    }

    @Substitute
    private void suspend0() {
        throw VMError.unsupportedFeature("The deprecated method Thread.suspend is not supported");
    }

    @Substitute
    private void resume0() {
        throw VMError.unsupportedFeature("The deprecated method Thread.resume is not supported");
    }

    @Substitute
    private int countStackFrames() {
        throw VMError.unsupportedFeature("The deprecated method Thread.countStackFrames is not supported");
    }

    @Delete
    private static native void registerNatives();

    @Delete
    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    @Delete
    private static native Thread[] getThreads();

    @Substitute
    @TargetElement(onlyWith={NotLoomJDK.class})
    private boolean isAlive() {
        return JavaThreads.isAlive(this.threadStatus);
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    private boolean isAlive0() {
        return JavaThreads.isAlive(this.holder.threadStatus);
    }

    @Substitute
    @TargetElement(onlyWith={NotLoomJDK.class})
    private static void yield() {
        JavaThreads.singleton().yield();
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    private static void yield0() {
        JavaThreads.singleton().yield();
    }

    @Substitute
    @TargetElement(onlyWith={NotLoomJDK.class})
    private static void sleep(long millis) throws InterruptedException {
        JavaThreads.sleep(millis);
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    private static void sleep0(long millis) throws InterruptedException {
        JavaThreads.sleep(millis);
    }

    @Substitute
    private static boolean holdsLock(Object obj) {
        Objects.requireNonNull(obj);
        return MonitorSupport.singleton().isLockedByCurrentThread(obj);
    }

    @Substitute
    private StackTraceElement[] getStackTrace() {
        if (JavaThreads.isVirtual(JavaThreads.fromTarget(this))) {
            return this.asyncGetStackTrace();
        }
        return JavaThreads.getStackTrace(JavaThreads.fromTarget(this));
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    StackTraceElement[] asyncGetStackTrace() {
        throw VMError.shouldNotReachHere("only `VirtualThread.asyncGetStackTrace` should be called.");
    }

    @Substitute
    private static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        return JavaThreads.getAllStackTraces();
    }

    @Substitute
    @TargetElement(onlyWith={JDK14OrLater.class})
    private static void clearInterruptEvent() {
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    static Object[] scopedCache() {
        throw VMError.unimplemented();
    }

    @Substitute
    @TargetElement(onlyWith={LoomJDK.class})
    static void setScopedCache(Object[] cache) {
        throw VMError.unimplemented();
    }

    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    native Target_java_lang_Continuation getContinuation();

    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    public static native Thread startVirtualThread(Runnable var0);
}

