/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class NonmovableByteArrayReader {
    public static Pointer pointerTo(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            throw VMError.shouldNotReachHere("Returns a raw pointer and therefore must not be called at image build time.");
        }
        assert (byteIndex >= 0L && NumUtil.safeToInt((long)byteIndex) < NonmovableArrays.lengthOf(data));
        Pointer result = ((Pointer)data).add(NonmovableByteArrayReader.getByteArrayBaseOffset()).add(NumUtil.safeToInt((long)byteIndex));
        assert (result.equal((UnsignedWord)NonmovableArrays.addressOf(data, NumUtil.safeToInt((long)byteIndex)))) : "sanity check that the optimized code above does the right thing";
        return result;
    }

    public static int getS1(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS1((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readByte(0);
    }

    public static int getS2(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS2((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readShort(0);
    }

    public static int getS4(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS4((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readInt(0);
    }

    public static long getS8(NonmovableArray<Byte> data, long byteIndex) {
        if (SubstrateUtil.HOSTED) {
            return ByteArrayReader.getS8((byte[])NonmovableArrays.getHostedArray(data), byteIndex);
        }
        return NonmovableByteArrayReader.pointerTo(data, byteIndex).readLong(0);
    }

    public static int getU1(NonmovableArray<Byte> data, long byteIndex) {
        return NonmovableByteArrayReader.getS1(data, byteIndex) & 0xFF;
    }

    public static int getU2(NonmovableArray<Byte> data, long byteIndex) {
        return NonmovableByteArrayReader.getS2(data, byteIndex) & 0xFFFF;
    }

    public static long getU4(NonmovableArray<Byte> data, long byteIndex) {
        return (long)NonmovableByteArrayReader.getS4(data, byteIndex) & 0xFFFFFFFFL;
    }

    @Fold
    protected static int getByteArrayBaseOffset() {
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
    }
}

