/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.isolated.IsolatedSpeculationReason;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;

final class IsolateAwareMetaAccess
extends SubstrateMetaAccess {
    IsolateAwareMetaAccess() {
    }

    @Override
    public JavaConstant encodeSpeculation(SpeculationLog.Speculation speculation) {
        if (!SubstrateOptions.shouldCompileInIsolates()) {
            return super.encodeSpeculation(speculation);
        }
        if (speculation == SpeculationLog.NO_SPECULATION) {
            return SubstrateObjectConstant.forObject(speculation);
        }
        ClientHandle handle = ((IsolatedSpeculationReason)speculation.getReason()).getHandle();
        return new IsolatedObjectConstant(handle, false);
    }

    @Override
    public SpeculationLog.Speculation decodeSpeculation(JavaConstant constant, SpeculationLog speculationLog) {
        if (!SubstrateOptions.shouldCompileInIsolates()) {
            return super.decodeSpeculation(constant, speculationLog);
        }
        if (constant instanceof DirectSubstrateObjectConstant) {
            SpeculationLog.Speculation speculation = (SpeculationLog.Speculation)SubstrateObjectConstant.asObject((Constant)constant);
            assert (speculation == SpeculationLog.NO_SPECULATION);
            return speculation;
        }
        ClientHandle<SpeculationLog.SpeculationReason> reasonHandle = ((IsolatedObjectConstant)constant).getHandle();
        return new SubstrateSpeculationLog.SubstrateSpeculation(new IsolatedSpeculationReason(reasonHandle));
    }
}

