/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;

class SubstrateNodeFieldAccessor
extends NodeFieldAccessor.AbstractUnsafeNodeFieldAccessor {
    private final long offset;

    protected SubstrateNodeFieldAccessor(SubstrateField field, NodeFieldAccessor.NodeFieldKind nodeFieldKind) {
        super(nodeFieldKind, SubstrateNodeFieldAccessor.makeDeclaringClass(field), field.getName(), SubstrateNodeFieldAccessor.makeType(field));
        this.offset = SubstrateNodeFieldAccessor.makeOffset(field);
    }

    protected static boolean isChildrenField(SubstrateField field) {
        return field.truffleChildrenField;
    }

    protected static boolean isChildField(SubstrateField field) {
        return field.truffleChildField;
    }

    static Class<?> makeType(SubstrateField field) {
        if (field.getType().getStorageKind().isPrimitive()) {
            return field.getType().getStorageKind().toJavaClass();
        }
        return DynamicHub.toClass(field.getType().getHub());
    }

    static Class<?> makeDeclaringClass(SubstrateField field) {
        return DynamicHub.toClass(field.getDeclaringClass().getHub());
    }

    static long makeOffset(SubstrateField field) {
        assert (field.getLocation() >= 0);
        return field.getLocation();
    }

    public long getOffset() {
        return this.offset;
    }

    static SubstrateNodeFieldAccessor fromSubstrateField(SubstrateField field) {
        NodeFieldAccessor.NodeFieldKind nodeFieldKind = DynamicHub.toClass(field.getDeclaringClass().getHub()) == Node.class && field.getName().equals("parent") ? NodeFieldAccessor.NodeFieldKind.PARENT : (DynamicHub.toClass(field.getDeclaringClass().getHub()) == Node.class && field.getName().equals("nodeClass") ? NodeFieldAccessor.NodeFieldKind.NODE_CLASS : (SubstrateNodeFieldAccessor.isChildField(field) ? NodeFieldAccessor.NodeFieldKind.CHILD : (SubstrateNodeFieldAccessor.isChildrenField(field) ? NodeFieldAccessor.NodeFieldKind.CHILDREN : NodeFieldAccessor.NodeFieldKind.DATA)));
        return new SubstrateNodeFieldAccessor(field, nodeFieldKind);
    }
}

