/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ImageClassLoader {
    private static final int CLASS_LOADING_MAX_SCALING = 8;
    private static final int CLASS_LOADING_TIMEOUT_IN_MINUTES = 10;
    public final Platform platform;
    final NativeImageClassLoaderSupport classLoaderSupport;
    private final EconomicSet<Class<?>> applicationClasses = EconomicSet.create();
    private final EconomicSet<Class<?>> hostedOnlyClasses = EconomicSet.create();
    private final EconomicSet<Method> systemMethods = EconomicSet.create();
    private final EconomicSet<Field> systemFields = EconomicSet.create();

    ImageClassLoader(Platform platform, NativeImageClassLoaderSupport classLoaderSupport) {
        this.platform = platform;
        this.classLoaderSupport = classLoaderSupport;
    }

    public void initAllClasses() {
        ForkJoinPool executor = new ForkJoinPool(Math.min(Runtime.getRuntime().availableProcessors(), 8));
        this.classLoaderSupport.initAllClasses(executor, this);
        boolean completed = executor.awaitQuiescence(10L, TimeUnit.MINUTES);
        if (!completed) {
            throw VMError.shouldNotReachHere("timed out while initializing classes");
        }
        executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSystemElements(Class<?> systemClass) {
        Method[] declaredMethods = null;
        try {
            declaredMethods = systemClass.getDeclaredMethods();
        }
        catch (Throwable t) {
            ImageClassLoader.handleClassLoadingError(t);
        }
        if (declaredMethods != null) {
            for (Method systemMethod : declaredMethods) {
                if (!ImageClassLoader.annotationsAvailable(systemMethod) || !NativeImageGenerator.includedIn(this.platform, systemMethod.getAnnotation(Platforms.class))) continue;
                EconomicSet<Method> economicSet = this.systemMethods;
                synchronized (economicSet) {
                    this.systemMethods.add((Object)systemMethod);
                }
            }
        }
        Field[] declaredFields = null;
        try {
            declaredFields = systemClass.getDeclaredFields();
        }
        catch (Throwable t) {
            ImageClassLoader.handleClassLoadingError(t);
        }
        if (declaredFields != null) {
            for (Field systemField : declaredFields) {
                if (!ImageClassLoader.annotationsAvailable(systemField) || !NativeImageGenerator.includedIn(this.platform, systemField.getAnnotation(Platforms.class))) continue;
                EconomicSet<Field> economicSet = this.systemFields;
                synchronized (economicSet) {
                    this.systemFields.add((Object)systemField);
                }
            }
        }
    }

    private static boolean canLoadAnnotations(AnnotatedElement element) {
        try {
            element.getAnnotations();
            return true;
        }
        catch (Throwable t) {
            ImageClassLoader.handleClassLoadingError(t);
            return false;
        }
    }

    private static boolean annotationsAvailable(AnnotatedElement element) {
        try {
            Annotation[] annotations = element.getAnnotations();
            return annotations.length != 0;
        }
        catch (Throwable t) {
            ImageClassLoader.handleClassLoadingError(t);
            return false;
        }
    }

    static void handleClassLoadingError(Throwable t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClass(Class<?> clazz) {
        boolean inPlatform = true;
        boolean isHostedOnly = false;
        AnnotatedElement cur = clazz.getPackage();
        if (cur == null) {
            cur = clazz;
        }
        do {
            if (!ImageClassLoader.canLoadAnnotations(cur)) {
                return;
            }
            Platforms platformsAnnotation = cur.getAnnotation(Platforms.class);
            if (ImageClassLoader.containsHostedOnly(platformsAnnotation)) {
                isHostedOnly = true;
            } else if (!NativeImageGenerator.includedIn(this.platform, platformsAnnotation)) {
                inPlatform = false;
            }
            if (cur instanceof Package) {
                cur = clazz;
                continue;
            }
            try {
                cur = ((Class)cur).getEnclosingClass();
            }
            catch (Throwable t) {
                ImageClassLoader.handleClassLoadingError(t);
                cur = null;
            }
        } while (cur != null);
        if (inPlatform) {
            EconomicSet<Class<?>> economicSet;
            if (isHostedOnly) {
                economicSet = this.hostedOnlyClasses;
                synchronized (economicSet) {
                    this.hostedOnlyClasses.add(clazz);
                }
            }
            economicSet = this.applicationClasses;
            synchronized (economicSet) {
                this.applicationClasses.add(clazz);
            }
            this.findSystemElements(clazz);
        }
    }

    private static boolean containsHostedOnly(Platforms platformsAnnotation) {
        if (platformsAnnotation != null) {
            for (Class platformClass : platformsAnnotation.value()) {
                if (platformClass != Platform.HOSTED_ONLY.class) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration<URL> findResourcesByName(String resource) throws IOException {
        return this.classLoaderSupport.getClassLoader().getResources(resource);
    }

    public InputStream findResourceAsStreamByName(String resource) {
        return this.classLoaderSupport.getClassLoader().getResourceAsStream(resource);
    }

    @Deprecated
    public Class<?> findClassByName(String name) {
        return this.findClassByName(name, true);
    }

    @Deprecated
    public Class<?> findClassByName(String name, boolean failIfClassMissing) {
        TypeResult<Class<?>> result = this.findClass(name);
        if (failIfClassMissing) {
            return result.getOrFail();
        }
        return result.get();
    }

    public Class<?> findClassOrFail(String name) {
        return this.findClass(name).getOrFail();
    }

    public TypeResult<Class<?>> findClass(String name) {
        try {
            if (name.indexOf(46) == -1) {
                switch (name) {
                    case "boolean": {
                        return TypeResult.forClass(Boolean.TYPE);
                    }
                    case "char": {
                        return TypeResult.forClass(Character.TYPE);
                    }
                    case "float": {
                        return TypeResult.forClass(Float.TYPE);
                    }
                    case "double": {
                        return TypeResult.forClass(Double.TYPE);
                    }
                    case "byte": {
                        return TypeResult.forClass(Byte.TYPE);
                    }
                    case "short": {
                        return TypeResult.forClass(Short.TYPE);
                    }
                    case "int": {
                        return TypeResult.forClass(Integer.TYPE);
                    }
                    case "long": {
                        return TypeResult.forClass(Long.TYPE);
                    }
                    case "void": {
                        return TypeResult.forClass(Void.TYPE);
                    }
                }
            }
            return TypeResult.forClass(this.forName(name));
        }
        catch (ClassNotFoundException | LinkageError ex) {
            return TypeResult.forException(name, ex);
        }
    }

    Class<?> forName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this.classLoaderSupport.getClassLoader());
    }

    @Deprecated
    public List<String> getClasspath() {
        return this.classpath().stream().map(Path::toString).collect(Collectors.toList());
    }

    public List<Path> classpath() {
        return this.classLoaderSupport.classpath();
    }

    public List<Path> modulepath() {
        return this.classLoaderSupport.modulepath();
    }

    public List<Path> applicationClassPath() {
        return this.classLoaderSupport.applicationClassPath();
    }

    public List<Path> applicationModulePath() {
        return this.classLoaderSupport.applicationModulePath();
    }

    public <T> List<Class<? extends T>> findSubclasses(Class<T> baseClass, boolean includeHostedOnly) {
        ArrayList<Class<? extends T>> result = new ArrayList<Class<? extends T>>();
        ImageClassLoader.addSubclasses(this.applicationClasses, baseClass, result);
        if (includeHostedOnly) {
            ImageClassLoader.addSubclasses(this.hostedOnlyClasses, baseClass, result);
        }
        return result;
    }

    private static <T> void addSubclasses(EconomicSet<Class<?>> classes, Class<T> baseClass, ArrayList<Class<? extends T>> result) {
        for (Class systemClass : classes) {
            if (!baseClass.isAssignableFrom(systemClass)) continue;
            result.add(systemClass.asSubclass(baseClass));
        }
    }

    public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotationClass, boolean includeHostedOnly) {
        ArrayList result = new ArrayList();
        ImageClassLoader.addAnnotatedClasses(this.applicationClasses, annotationClass, result);
        if (includeHostedOnly) {
            ImageClassLoader.addAnnotatedClasses(this.hostedOnlyClasses, annotationClass, result);
        }
        return result;
    }

    private static void addAnnotatedClasses(EconomicSet<Class<?>> classes, Class<? extends Annotation> annotationClass, ArrayList<Class<?>> result) {
        for (Class systemClass : classes) {
            if (systemClass.getAnnotation(annotationClass) == null) continue;
            result.add(systemClass);
        }
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.systemMethods) {
            if (method.getAnnotation(annotationClass) == null) continue;
            result.add(method);
        }
        return result;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation>[] annotationClasses) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.systemMethods) {
            boolean match = true;
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (method.getAnnotation(annotationClass) != null) continue;
                match = false;
                break;
            }
            if (!match) continue;
            result.add(method);
        }
        return result;
    }

    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotationClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : this.systemFields) {
            if (field.getAnnotation(annotationClass) == null) continue;
            result.add(field);
        }
        return result;
    }

    public List<Class<? extends Annotation>> allAnnotations() {
        return StreamSupport.stream(this.applicationClasses.spliterator(), false).filter(Class::isAnnotation).map(clazz -> clazz).collect(Collectors.toList());
    }

    public <T extends Annotation> List<T> findAnnotations(Class<T> annotationClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (Class<?> clazz : this.findAnnotatedClasses(annotationClass, false)) {
            result.add(clazz.getAnnotation(annotationClass));
        }
        for (Method method : this.findAnnotatedMethods(annotationClass)) {
            result.add(method.getAnnotation(annotationClass));
        }
        for (Field field : this.findAnnotatedFields(annotationClass)) {
            result.add(field.getAnnotation(annotationClass));
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderSupport.getClassLoader();
    }

    public Class<?> loadClassFromModule(Object module, String className) throws ClassNotFoundException {
        return this.classLoaderSupport.loadClassFromModule(module, className);
    }

    public Optional<Object> findModule(String moduleName) {
        return this.classLoaderSupport.findModule(moduleName);
    }

    public void processAddExportsAndAddOpens(OptionValues parsedHostedOptions) {
        this.classLoaderSupport.processAddExportsAndAddOpens(parsedHostedOptions);
    }

    static {
        Word.ensureInitialized();
    }
}

