/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.localization.LocalizationFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.util.ModuleSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.home.HomeFinder;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public final class ResourcesFeature
implements Feature {
    private boolean sealed = false;
    private final Set<String> resourcePatternWorkSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> excludedResourcePatterns = Collections.newSetFromMap(new ConcurrentHashMap());
    private int loadedConfigurations;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(ResourcesRegistry.class, (Object)new ResourcesRegistryImpl());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ImageClassLoader imageClassLoader = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getImageClassLoader();
        ResourceConfigurationParser parser = new ResourceConfigurationParser((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class));
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "resource", ConfigurationFiles.Options.ResourceConfigurationFiles, ConfigurationFiles.Options.ResourceConfigurationResources, ConfigurationFile.RESOURCES.getFileName());
        this.resourcePatternWorkSet.addAll(Options.IncludeResources.getValue().values());
        this.excludedResourcePatterns.addAll(Options.ExcludeResources.getValue().values());
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.resourcePatternWorkSet.isEmpty()) {
            return;
        }
        access.requireAnalysisIteration();
        DebugContext debugContext = ((FeatureImpl.DuringAnalysisAccessImpl)access).getDebugContext();
        Pattern[] includePatterns = ResourcesFeature.compilePatterns(this.resourcePatternWorkSet);
        Pattern[] excludePatterns = ResourcesFeature.compilePatterns(this.excludedResourcePatterns);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            try {
                ModuleSupport.findResourcesInModules(name -> ResourcesFeature.matches(includePatterns, excludePatterns, name), (resName, content) -> ResourcesFeature.registerResource(debugContext, resName, content));
            }
            catch (IOException ex) {
                throw UserError.abort(ex, "Can not read resources from modules. This is possible due to incorrect module path or missing module visibility directives", new Object[0]);
            }
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<File> userClasspathFiles = new LinkedHashSet<File>();
        LinkedHashSet<File> supportLibraries = new LinkedHashSet<File>();
        String homeFolder = HomeFinder.getInstance().getHomeFolder().toString();
        if (contextClassLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)contextClassLoader).getURLs()) {
                try {
                    File file = new File(url.toURI());
                    if (file.getAbsolutePath().startsWith(homeFolder)) {
                        supportLibraries.add(file);
                        continue;
                    }
                    userClasspathFiles.add(file);
                }
                catch (IllegalArgumentException | URISyntaxException e) {
                    throw UserError.abort("Unable to handle image classpath element '%s'. Make sure that all image classpath entries are either directories or valid jar files.", url.toExternalForm());
                }
            }
        }
        userClasspathFiles.addAll(supportLibraries);
        for (File classpathFile : userClasspathFiles) {
            try {
                if (classpathFile.isDirectory()) {
                    ResourcesFeature.scanDirectory(debugContext, classpathFile, includePatterns, excludePatterns);
                    continue;
                }
                if (!ClasspathUtils.isJar(classpathFile.toPath())) continue;
                ResourcesFeature.scanJar(debugContext, classpathFile, includePatterns, excludePatterns);
            }
            catch (IOException ex) {
                throw UserError.abort("Unable to handle classpath element '%s'. Make sure that all classpath entries are either directories or valid jar files.", classpathFile);
            }
        }
        this.resourcePatternWorkSet.clear();
    }

    private static Pattern[] compilePatterns(Set<String> patterns) {
        return patterns.stream().filter(s -> s.length() > 0).map(Pattern::compile).collect(Collectors.toList()).toArray(new Pattern[0]);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest resourceFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).resourceFallback;
        if (resourceFallback != null && Options.IncludeResources.getValue().values().isEmpty() && this.loadedConfigurations == 0) {
            throw resourceFallback;
        }
    }

    private static void scanDirectory(DebugContext debugContext, File root, Pattern[] includePatterns, Pattern[] excludePatterns) throws IOException {
        HashMap<String, List> matchedDirectoryResources = new HashMap<String, List>();
        HashSet<String> allEntries = new HashSet<String>();
        ArrayList<File> queue = new ArrayList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File file = (File)queue.remove(0);
            String relativeFilePath = "";
            if (file != root) {
                relativeFilePath = file.getAbsolutePath().substring(root.getAbsolutePath().length() + 1);
                relativeFilePath = relativeFilePath.replace(File.separatorChar, '/');
            }
            if (file.isDirectory()) {
                File[] files;
                if (!relativeFilePath.isEmpty()) {
                    allEntries.add(relativeFilePath);
                }
                if (ResourcesFeature.matches(includePatterns, excludePatterns, relativeFilePath)) {
                    matchedDirectoryResources.put(relativeFilePath, new ArrayList());
                }
                if ((files = file.listFiles()) == null) {
                    throw UserError.abort("Cannot scan directory %s", file);
                }
                queue.addAll(Arrays.asList(files));
                continue;
            }
            allEntries.add(relativeFilePath);
            if (!ResourcesFeature.matches(includePatterns, excludePatterns, relativeFilePath)) continue;
            FileInputStream is = new FileInputStream(file);
            Throwable throwable = null;
            try {
                ResourcesFeature.registerResource(debugContext, relativeFilePath, is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)is).close();
            }
        }
        for (String entry : allEntries) {
            int last = entry.lastIndexOf(47);
            String key = last == -1 ? "" : entry.substring(0, last);
            List dirContent = (List)matchedDirectoryResources.get(key);
            if (dirContent == null || dirContent.contains(entry)) continue;
            dirContent.add(entry.substring(last + 1));
        }
        matchedDirectoryResources.forEach((dir, content) -> {
            content.sort(Comparator.naturalOrder());
            ResourcesFeature.registerDirectoryResource(debugContext, dir, String.join((CharSequence)System.lineSeparator(), content));
        });
    }

    private static void scanJar(DebugContext debugContext, File root, Pattern[] includePatterns, Pattern[] excludePatterns) throws IOException {
        JarFile jf = new JarFile(root);
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                String dirName = entry.getName().substring(0, entry.getName().length() - 1);
                if (!ResourcesFeature.matches(includePatterns, excludePatterns, dirName)) continue;
                ResourcesFeature.registerDirectoryResource(debugContext, dirName, "");
                continue;
            }
            if (!ResourcesFeature.matches(includePatterns, excludePatterns, entry.getName())) continue;
            InputStream is = jf.getInputStream(entry);
            Throwable throwable = null;
            try {
                ResourcesFeature.registerResource(debugContext, entry.getName(), is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private static boolean matches(Pattern[] includePatterns, Pattern[] excludePatterns, String relativePath) {
        for (Pattern p : excludePatterns) {
            if (!p.matcher(relativePath).matches()) continue;
            return false;
        }
        for (Pattern p : includePatterns) {
            if (!p.matcher(relativePath).matches()) continue;
            return true;
        }
        return false;
    }

    private static void registerResource(DebugContext debugContext, String resourceName, InputStream resourceStream) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            debugContext.log(3, "ResourcesFeature: registerResource: " + resourceName);
            Resources.registerResource(resourceName, resourceStream);
        }
    }

    private static void registerDirectoryResource(DebugContext debugContext, String dir, String content) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            debugContext.log(3, "ResourcesFeature: registerResource: " + dir);
            Resources.registerDirectoryResource(dir, content);
        }
    }

    private class ResourcesRegistryImpl
    implements ResourcesRegistry {
        private ResourcesRegistryImpl() {
        }

        @Override
        public void addResources(String pattern) {
            UserError.guarantee(!ResourcesFeature.this.sealed, "Resources added too late: %s", pattern);
            ResourcesFeature.this.resourcePatternWorkSet.add(pattern);
        }

        @Override
        public void ignoreResources(String pattern) {
            UserError.guarantee(!ResourcesFeature.this.sealed, "Resources ignored too late: %s", pattern);
            ResourcesFeature.this.excludedResourcePatterns.add(pattern);
        }

        @Override
        public void addResourceBundles(String name) {
            ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(name);
        }
    }

    public static class Options {
        @Option(help={"Regexp to match names of resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @Option(help={"Regexp to match names of resources to be excluded from the image."}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ExcludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    }
}

